/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coc.block;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.coc.CocModElements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;

@CocModElements.ModElement.Tag
public class AshrootGrowthBlock
extends CocModElements.ModElement {
    @ObjectHolder(value="coc:ashroot_bramble")
    public static final Block block = null;

    public AshrootGrowthBlock(CocModElements instance) {
        super(instance, 958);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomBlock(Block.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c)));
        this.elements.items.add(() -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(block.getRegistryName()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_());
    }

    public static class CustomBlock
    extends Block
    implements IShearable {
        public static final BooleanProperty UP = SixWayBlock.field_196496_z;
        public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
        public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
        public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
        public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
        public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
        public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199782_0_ -> true).collect(Util.func_199749_a());
        protected static final VoxelShape UP_AABB = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        protected static final VoxelShape DOWN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

        public CustomBlock(Block.Properties properties) {
            super(properties);
            this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
            this.setRegistryName("ashroot_bramble");
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            VoxelShape voxelshape = VoxelShapes.func_197880_a();
            if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)UP_AABB);
            }
            if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)DOWN_AABB);
            }
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
            }
            return voxelshape;
        }

        public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
            return this.func_196543_i(this.func_196545_h(state, (IBlockReader)worldIn, pos));
        }

        private boolean func_196543_i(BlockState p_196543_1_) {
            return this.countBlocksVineIsAttachedTo(p_196543_1_) > 0;
        }

        private int countBlocksVineIsAttachedTo(BlockState p_208496_1_) {
            int i = 0;
            for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
                if (!((Boolean)p_208496_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
                ++i;
            }
            return i;
        }

        private boolean func_196541_a(IBlockReader p_196541_1_, BlockPos p_196541_2_, Direction p_196541_3_) {
            BlockPos blockpos = p_196541_2_.func_177972_a(p_196541_3_);
            if (CustomBlock.canAttachTo(p_196541_1_, blockpos, p_196541_3_)) {
                return true;
            }
            if (p_196541_3_.func_176740_k() == Direction.Axis.Y) {
                return false;
            }
            BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(p_196541_3_);
            BlockState blockstate = p_196541_1_.func_180495_p(p_196541_2_.func_177984_a());
            return blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
        }

        public static boolean canAttachTo(IBlockReader p_196542_0_, BlockPos worldIn, Direction neighborPos) {
            BlockState blockstate = p_196542_0_.func_180495_p(worldIn);
            return Block.func_208061_a((VoxelShape)blockstate.func_196952_d(p_196542_0_, worldIn), (Direction)neighborPos.func_176734_d());
        }

        private BlockState func_196545_h(BlockState p_196545_1_, IBlockReader p_196545_2_, BlockPos p_196545_3_) {
            BlockPos blockpos = p_196545_3_.func_177984_a();
            if (((Boolean)p_196545_1_.func_177229_b((IProperty)UP)).booleanValue()) {
                p_196545_1_ = (BlockState)p_196545_1_.func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(CustomBlock.canAttachTo(p_196545_2_, blockpos, Direction.DOWN)));
            }
            BlockState blockstate = null;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BooleanProperty booleanproperty = CustomBlock.getPropertyFor(direction);
                if (!((Boolean)p_196545_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
                boolean flag = this.func_196541_a(p_196545_2_, p_196545_3_, direction);
                if (!flag) {
                    if (blockstate == null) {
                        blockstate = p_196545_2_.func_180495_p(blockpos);
                    }
                    flag = blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
                }
                p_196545_1_ = (BlockState)p_196545_1_.func_206870_a((IProperty)booleanproperty, (Comparable)Boolean.valueOf(flag));
            }
            return p_196545_1_;
        }

        public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
            BlockState blockstate = this.func_196545_h(stateIn, (IBlockReader)worldIn, currentPos);
            return !this.func_196543_i(blockstate) ? Blocks.field_150350_a.func_176223_P() : blockstate;
        }

        public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        }

        private BlockState func_196544_a(BlockState p_196544_1_, BlockState p_196544_2_, Random p_196544_3_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BooleanProperty booleanproperty;
                if (!p_196544_3_.nextBoolean() || !((Boolean)p_196544_1_.func_177229_b((IProperty)(booleanproperty = CustomBlock.getPropertyFor(direction)))).booleanValue()) continue;
                p_196544_2_ = (BlockState)p_196544_2_.func_206870_a((IProperty)booleanproperty, (Comparable)Boolean.valueOf(true));
            }
            return p_196544_2_;
        }

        private boolean func_196540_x(BlockState p_196540_1_) {
            return (Boolean)p_196540_1_.func_177229_b((IProperty)NORTH) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)EAST) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)SOUTH) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)WEST) != false;
        }

        private boolean func_196539_a(IBlockReader p_196539_1_, BlockPos p_196539_2_) {
            int i = 4;
            Iterable iterable = BlockPos.func_191531_b((int)(p_196539_2_.func_177958_n() - 4), (int)(p_196539_2_.func_177956_o() - 1), (int)(p_196539_2_.func_177952_p() - 4), (int)(p_196539_2_.func_177958_n() + 4), (int)(p_196539_2_.func_177956_o() + 1), (int)(p_196539_2_.func_177952_p() + 4));
            int j = 5;
            for (BlockPos blockpos : iterable) {
                if (p_196539_1_.func_180495_p(blockpos).func_177230_c() != this || --j > 0) continue;
                return false;
            }
            return true;
        }

        public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
            BlockState blockstate = useContext.func_195991_k().func_180495_p(useContext.func_195995_a());
            if (blockstate.func_177230_c() == this) {
                return this.countBlocksVineIsAttachedTo(blockstate) < FACING_TO_PROPERTY_MAP.size();
            }
            return super.func_196253_a(state, useContext);
        }

        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
            boolean flag = blockstate.func_177230_c() == this;
            BlockState blockstate1 = flag ? blockstate : this.func_176223_P();
            for (Direction direction : context.func_196009_e()) {
                boolean flag1;
                BooleanProperty booleanproperty = CustomBlock.getPropertyFor(direction);
                boolean bl = flag1 = flag && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
                if (flag1 || !this.func_196541_a((IBlockReader)context.func_195991_k(), context.func_195995_a(), direction)) continue;
                return (BlockState)blockstate1.func_206870_a((IProperty)booleanproperty, (Comparable)Boolean.valueOf(true));
            }
            return flag ? blockstate1 : null;
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            switch (rot) {
                case CLOCKWISE_180: {
                    return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
                }
                case COUNTERCLOCKWISE_90: {
                    return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
                }
                case CLOCKWISE_90: {
                    return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
                }
            }
            return state;
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            switch (mirrorIn) {
                case LEFT_RIGHT: {
                    return (BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
                }
                case FRONT_BACK: {
                    return (BlockState)((BlockState)state.func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
                }
            }
            return super.func_185471_a(state, mirrorIn);
        }

        public static BooleanProperty getPropertyFor(Direction side) {
            return FACING_TO_PROPERTY_MAP.get(side);
        }
    }
}

