/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coc.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mcreator.coc.CocModElements;
import net.mcreator.coc.item.TunnelbugHideItem;
import net.mcreator.coc.particle.LavaWakeParticle;
import net.mcreator.coc.particle.StunEffectParticle;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@CocModElements.ModElement.Tag
public class CorruptGrubEntity
extends CocModElements.ModElement {
    public static EntityType entity = null;

    public CorruptGrubEntity(CocModElements instance) {
        super(instance, 678);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.5f, 0.5f).func_206830_a("scoria").setRegistryName("scoria");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10092544, -6737152, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("scoria_spawn_egg"));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelCorruptGrub(), 0.5f){

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("coc:textures/corrupt_grub.png");
            }
        });
    }

    public static class ModelCorruptGrub
    extends EntityModel<Entity> {
        public ModelRenderer Segment1;
        public ModelRenderer Segment2;
        public ModelRenderer SideFinL;
        public ModelRenderer SideFinR;
        public ModelRenderer Tusk1;
        public ModelRenderer Tusk2;
        public ModelRenderer Tusk3;
        public ModelRenderer Tusk3_1;
        public ModelRenderer Segment3;

        public ModelCorruptGrub() {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.SideFinL = new ModelRenderer((Model)this, -1, 21);
            this.SideFinL.field_78809_i = true;
            this.SideFinL.func_78793_a(3.0f, 0.0f, -0.5f);
            this.SideFinL.func_228301_a_(0.0f, 0.0f, -2.0f, 3.0f, 0.0f, 11.0f, 0.0f);
            this.Segment1 = new ModelRenderer((Model)this, 0, 0);
            this.Segment1.func_78793_a(0.0f, 21.0f, -2.5f);
            this.Segment1.func_228301_a_(-3.0f, -3.0f, -3.5f, 6.0f, 6.0f, 7.0f, 0.0f);
            this.Tusk3 = new ModelRenderer((Model)this, 0, 0);
            this.Tusk3.func_78793_a(-0.4f, 0.0f, -2.5f);
            this.Tusk3.func_228301_a_(-2.5f, -1.0f, -3.0f, 1.0f, 2.0f, 2.0f, 0.0f);
            this.setRotateAngle(this.Tusk3, 0.0f, 0.0f, -0.7853982f);
            this.Tusk3_1 = new ModelRenderer((Model)this, 0, 0);
            this.Tusk3_1.func_78793_a(0.4f, 0.0f, -2.5f);
            this.Tusk3_1.func_228301_a_(-2.5f, -1.0f, -3.0f, 1.0f, 2.0f, 2.0f, 0.0f);
            this.setRotateAngle(this.Tusk3_1, 0.0f, 0.0f, -2.3561945f);
            this.Segment3 = new ModelRenderer((Model)this, 0, 21);
            this.Segment3.func_78793_a(-1.5f, -1.0f, 4.0f);
            this.Segment3.func_228301_a_(0.0f, 0.0f, 0.0f, 3.0f, 2.0f, 2.0f, 0.0f);
            this.Segment2 = new ModelRenderer((Model)this, 0, 13);
            this.Segment2.func_78793_a(0.0f, 0.0f, 3.5f);
            this.Segment2.func_228301_a_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 4.0f, 0.0f);
            this.SideFinR = new ModelRenderer((Model)this, -1, 21);
            this.SideFinR.func_78793_a(-3.0f, 0.0f, -2.5f);
            this.SideFinR.func_228301_a_(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 11.0f, 0.0f);
            this.Tusk1 = new ModelRenderer((Model)this, 0, 0);
            this.Tusk1.func_78793_a(-0.4f, 0.0f, -2.5f);
            this.Tusk1.func_228301_a_(-2.5f, -1.0f, -3.0f, 1.0f, 2.0f, 2.0f, 0.0f);
            this.setRotateAngle(this.Tusk1, 0.0f, 0.0f, 0.7853982f);
            this.Tusk2 = new ModelRenderer((Model)this, 0, 0);
            this.Tusk2.func_78793_a(0.4f, 0.0f, -2.5f);
            this.Tusk2.func_228301_a_(-2.5f, -1.0f, -3.0f, 1.0f, 2.0f, 2.0f, 0.0f);
            this.setRotateAngle(this.Tusk2, 0.0f, 0.0f, 2.3561945f);
            this.Segment1.func_78792_a(this.SideFinL);
            this.Segment1.func_78792_a(this.Tusk3);
            this.Segment1.func_78792_a(this.Tusk3_1);
            this.Segment2.func_78792_a(this.Segment3);
            this.Segment1.func_78792_a(this.Segment2);
            this.Segment1.func_78792_a(this.SideFinR);
            this.Segment1.func_78792_a(this.Tusk1);
            this.Segment1.func_78792_a(this.Tusk2);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            GlStateManager.func_227771_z_();
            this.Segment1.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            GlStateManager.func_227605_A_();
        }

        public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.Segment2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1 / 3.0f;
            this.Segment1.field_78796_g = f3 / 57.295776f;
            this.Segment1.field_78795_f = f4 / 57.295776f;
            this.Segment3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1 / 5.0f;
            this.SideFinR.field_78808_h = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1 / 10.0f;
            this.SideFinL.field_78808_h = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1 / 10.0f;
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        Random random;
        int dashTimer;
        boolean noGravity;
        int followCool;
        double tX;
        double tY;
        double tZ;
        double rX;
        double rY;
        double rZ;
        double presetAngle;
        double targetYaw;

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.random = this.field_70146_Z;
            this.dashTimer = 0;
            this.noGravity = false;
            this.followCool = 0;
            this.presetAngle = (Math.random() - 0.5) * 10.0;
            this.targetYaw = 0.0;
            this.field_70728_aV = 5;
            this.func_94061_f(false);
        }

        protected void func_184651_r() {
            this.field_70765_h = new AIMoveControl(this);
            this.field_70714_bg.func_75776_a(2, (Goal)new SwimLavaGoal());
            this.field_70714_bg.func_75776_a(1, (Goal)new SwimToTargetGoal());
            this.field_70714_bg.func_75776_a(0, (Goal)new DashAttackGoal());
            this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.dashTimer > 0) {
                --this.dashTimer;
            }
            if (this.followCool > 0) {
                this.field_70125_A += 5.0f;
                --this.followCool;
                this.field_70170_p.func_195594_a((IParticleData)StunEffectParticle.particle, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            if (this.func_180799_ab() && !this.noGravity) {
                this.func_189654_d(true);
                this.noGravity = true;
            }
            if (this.field_70122_E) {
                this.func_70024_g(Math.random() / 2.0 - 0.25, 0.25, Math.random() / 2.0 - 0.25);
                this.func_189654_d(false);
                this.noGravity = false;
            }
            if (Math.random() < 0.5 && this.func_180799_ab()) {
                this.field_70170_p.func_195594_a((IParticleData)LavaWakeParticle.particle, this.func_226277_ct_() + Math.random() - 0.5, this.func_226278_cu_() + Math.random() - 0.5, this.func_226281_cx_() + Math.random() - 0.5, (Math.random() - 0.5) / 5.0, (Math.random() - 0.5) / 5.0, (Math.random() - 0.5) / 5.0);
            }
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223224_c_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)TunnelbugHideItem.block, 1));
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("coc:entity.scoria.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("coc:entity.scoria.death"));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
        }

        class AIMoveControl
        extends MovementController {
            public AIMoveControl(CustomEntity magmaw) {
                super((MobEntity)magmaw);
            }

            public void func_75641_c() {
                if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                    Vec3d vec3d = new Vec3d(this.field_75646_b - CustomEntity.this.func_226277_ct_(), this.field_75647_c - CustomEntity.this.func_226278_cu_(), this.field_75644_d - CustomEntity.this.func_226281_cx_());
                    double d0 = vec3d.func_72433_c();
                    if (d0 < CustomEntity.this.func_174813_aQ().func_72320_b()) {
                        this.field_188491_h = MovementController.Action.WAIT;
                        CustomEntity.this.func_213317_d(CustomEntity.this.func_213322_ci().func_186678_a(0.5));
                    } else {
                        CustomEntity.this.func_213317_d(CustomEntity.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                        if (CustomEntity.this.func_70638_az() == null) {
                            Vec3d vec3d1 = CustomEntity.this.func_213322_ci();
                            CustomEntity.this.field_70761_aq = CustomEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                        } else {
                            double d2 = CustomEntity.this.func_70638_az().func_226277_ct_() - this.field_75646_b;
                            double d1 = CustomEntity.this.func_70638_az().func_226281_cx_() - this.field_75644_d;
                            CustomEntity.this.field_70761_aq = CustomEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                        }
                    }
                }
            }
        }

        class SwimToTargetGoal
        extends Goal {
            SwimToTargetGoal() {
            }

            public boolean func_75250_a() {
                return CustomEntity.this.func_180799_ab() && CustomEntity.this.func_70638_az() != null && CustomEntity.this.followCool == 0 && CustomEntity.this.func_70638_az().func_180799_ab();
            }

            public boolean func_75253_b() {
                return CustomEntity.this.func_70638_az() != null && CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az()) > 89.0 && CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az()) < 1000.0 && CustomEntity.this.func_70638_az().func_70089_S() && CustomEntity.this.followCool == 0 && CustomEntity.this.func_180799_ab();
            }

            public void func_75249_e() {
            }

            public void func_75246_d() {
                LivingEntity target = CustomEntity.this.func_70638_az();
                if (Math.abs(target.func_213322_ci().field_72450_a) < 0.2 && Math.abs(target.func_213322_ci().field_72448_b) < 0.2 && Math.abs(target.func_213322_ci().field_72449_c) < 0.2) {
                    CustomEntity.this.targetYaw += 0.2;
                    double swimAngle = CustomEntity.this.targetYaw / 2.0 + CustomEntity.this.presetAngle;
                    double length = 3.0;
                    double lengthX = Math.cos(swimAngle) * length;
                    double lengthZ = Math.sin(swimAngle) * length;
                    CustomEntity.this.func_70671_ap().func_75650_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 180.0f, 20.0f);
                    CustomEntity.this.field_70765_h.func_75642_a(target.func_226277_ct_() + lengthX, target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_() + lengthZ, 5.0);
                } else {
                    CustomEntity.this.field_70765_h.func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 2.0);
                }
            }
        }

        class DashAttackGoal
        extends Goal {
            DashAttackGoal() {
            }

            public boolean func_75250_a() {
                return CustomEntity.this.dashTimer == 0 && CustomEntity.this.func_70638_az() != null && CustomEntity.this.func_180799_ab() && CustomEntity.this.func_70638_az().func_180799_ab() && CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az()) < 90.0 && Math.random() < 0.5;
            }

            public void func_75246_d() {
                LivingEntity target = CustomEntity.this.func_70638_az();
                if (CustomEntity.this.func_174813_aQ().func_72326_a(CustomEntity.this.func_70638_az().func_174813_aQ())) {
                    CustomEntity.this.func_70652_k((Entity)CustomEntity.this.func_70638_az());
                    CustomEntity.this.dashTimer = 100;
                    CustomEntity.this.followCool = 30;
                    CustomEntity.this.field_70765_h.func_75642_a(CustomEntity.this.func_70040_Z().field_72450_a * -0.5, CustomEntity.this.func_70040_Z().field_72448_b * -0.5, CustomEntity.this.func_70040_Z().field_72449_c * -0.5, 0.1);
                } else {
                    double tX = (CustomEntity.this.func_70638_az().func_226277_ct_() - CustomEntity.this.func_226277_ct_()) / CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az());
                    double tY = (CustomEntity.this.func_70638_az().func_226278_cu_() - CustomEntity.this.func_226278_cu_()) / CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az());
                    double tZ = (CustomEntity.this.func_70638_az().func_226281_cx_() - CustomEntity.this.func_226281_cx_()) / CustomEntity.this.func_70068_e((Entity)CustomEntity.this.func_70638_az());
                    CustomEntity.this.func_70024_g(tX / 1.5, tY / 1.5, tZ / 1.5);
                    CustomEntity.this.func_70671_ap().func_75650_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 180.0f, 20.0f);
                }
            }
        }

        class SwimLavaGoal
        extends Goal {
            SwimLavaGoal() {
            }

            public boolean func_75250_a() {
                return CustomEntity.this.func_180799_ab() && Math.random() < 0.05;
            }

            public void func_75246_d() {
                BlockPos bpos = new BlockPos((Vec3i)CustomEntity.this.func_180425_c());
                if (CustomEntity.this.func_70638_az() == null) {
                    for (int i = 0; i < 20; ++i) {
                        BlockPos blockpos1 = bpos.func_177982_a(CustomEntity.this.field_70146_Z.nextInt(30) - 15, CustomEntity.this.field_70146_Z.nextInt(11) - 5, CustomEntity.this.field_70146_Z.nextInt(30) - 15);
                        if (CustomEntity.this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos1)).func_177230_c() != Blocks.field_150353_l) continue;
                        if (CustomEntity.this.func_180799_ab()) {
                            CustomEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 2.0);
                        } else {
                            CustomEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                        }
                        if (CustomEntity.this.func_70638_az() != null) break;
                        CustomEntity.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                        break;
                    }
                } else {
                    for (int i = 0; i < 20; ++i) {
                        BlockPos blockpos1 = bpos.func_177982_a(CustomEntity.this.field_70146_Z.nextInt(30) - 15, CustomEntity.this.field_70146_Z.nextInt(11) - 5, CustomEntity.this.field_70146_Z.nextInt(30) - 15);
                        if (CustomEntity.this.field_70170_p.func_180495_p(new BlockPos((Vec3i)blockpos1)).func_177230_c() != Blocks.field_150353_l || !CustomEntity.this.field_70170_p.func_175623_d(new BlockPos(blockpos1.func_177958_n(), blockpos1.func_177956_o() + 1, blockpos1.func_177952_p()))) continue;
                        if (CustomEntity.this.func_180799_ab()) {
                            CustomEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 2.0);
                        } else {
                            CustomEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                        }
                        break;
                    }
                }
            }
        }
    }
}

