/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.chanceglobe.tileentity;

import bl4ckscor3.mod.chanceglobe.ChanceGlobe;
import bl4ckscor3.mod.chanceglobe.Configuration;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChanceGlobeTileEntity
extends BlockEntity {
    public static final Random random = new Random(System.currentTimeMillis());
    private ItemStack clientItem = ItemStack.f_41583_;
    public ItemStack serverItem = ItemStack.f_41583_;
    public final double secondsUntilDrop;
    public double tickToDrop;
    public int ticksUntilDrop;
    public int ticksUntilChange;

    public ChanceGlobeTileEntity(BlockPos pos, BlockState state) {
        super(ChanceGlobe.teTypeGlobe, pos, state);
        this.secondsUntilDrop = 10.0 * (Double)Configuration.CONFIG.durationMultiplier.get();
        this.tickToDrop = this.secondsUntilDrop * 20.0;
        this.ticksUntilDrop = 0;
        this.ticksUntilChange = this.getNextChangeTick(this.ticksUntilDrop);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ChanceGlobeTileEntity te) {
        if (ChanceGlobe.blocksAndItems.size() <= 0) {
            return;
        }
        if (te.ticksUntilChange == 0 || te.clientItem.m_41619_()) {
            te.ticksUntilChange = te.getNextChangeTick(te.ticksUntilDrop);
            te.clientItem = ChanceGlobe.blocksAndItems.get(random.nextInt(ChanceGlobe.blocksAndItems.size()));
        } else {
            --te.ticksUntilChange;
        }
        if ((double)te.ticksUntilDrop != te.tickToDrop) {
            ++te.ticksUntilDrop;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChanceGlobeTileEntity te) {
        if (ChanceGlobe.blocksAndItems.size() <= 0) {
            return;
        }
        if (te.serverItem.m_41619_()) {
            te.serverItem = ChanceGlobe.blocksAndItems.get(random.nextInt(ChanceGlobe.blocksAndItems.size()));
        }
        if ((double)te.ticksUntilDrop++ == te.tickToDrop) {
            level.m_46961_(te.f_58858_, false);
            Item item = te.serverItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                level.m_46597_(te.f_58858_, blockItem.m_40614_().m_49966_());
            } else {
                Block.m_49840_((Level)level, (BlockPos)te.f_58858_, (ItemStack)te.serverItem);
            }
        }
    }

    public ItemStack getClientItem() {
        return this.clientItem;
    }

    public int getNextChangeTick(int remainingTicksToDrop) {
        return (int)(Math.pow((double)(remainingTicksToDrop / 20) - this.secondsUntilDrop, 2.0) / 2.5);
    }
}

