/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese;

import coffeecatrailway.coffeecheese.ModCheeseConfig;
import coffeecatrailway.coffeecheese.ModItemGroups;
import coffeecatrailway.coffeecheese.client.render.entity.BoatRendererCM;
import coffeecatrailway.coffeecheese.client.render.entity.FoodieRenderer;
import coffeecatrailway.coffeecheese.client.render.tileentity.FoodWorldPortalTileEntityRenderer;
import coffeecatrailway.coffeecheese.client.render.tileentity.GrillTileEntityRenderer;
import coffeecatrailway.coffeecheese.client.render.tileentity.MelterTileEntityRenderer;
import coffeecatrailway.coffeecheese.client.render.tileentity.PizzaOvenTileEntityRenderer;
import coffeecatrailway.coffeecheese.common.command.ChezCommand;
import coffeecatrailway.coffeecheese.common.entity.CheeseBallEntity;
import coffeecatrailway.coffeecheese.common.entity.CheeseFoodie;
import coffeecatrailway.coffeecheese.common.entity.GrilledCheeseFoodie;
import coffeecatrailway.coffeecheese.common.entity.HamCookedFoodie;
import coffeecatrailway.coffeecheese.common.entity.HamRawFoodie;
import coffeecatrailway.coffeecheese.common.entity.item.BoatEntityCM;
import coffeecatrailway.coffeecheese.common.tileentity.FoodWorldPortalTileEntity;
import coffeecatrailway.coffeecheese.common.tileentity.GrillTileEntity;
import coffeecatrailway.coffeecheese.common.tileentity.MelterTileEntity;
import coffeecatrailway.coffeecheese.common.tileentity.PizzaOvenTileEntity;
import coffeecatrailway.coffeecheese.common.world.ModWorldFeatures;
import coffeecatrailway.coffeecheese.common.world.dimension.FoodWorldTeleporter;
import coffeecatrailway.coffeecheese.compat.jer.JEResourcesCompat;
import coffeecatrailway.coffeecheese.compat.top.TOPCompatibility;
import coffeecatrailway.coffeecheese.registry.ModBiomes;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModContainers;
import coffeecatrailway.coffeecheese.registry.ModDimensions;
import coffeecatrailway.coffeecheese.registry.ModEnchantments;
import coffeecatrailway.coffeecheese.registry.ModEntities;
import coffeecatrailway.coffeecheese.registry.ModFeatures;
import coffeecatrailway.coffeecheese.registry.ModFluids;
import coffeecatrailway.coffeecheese.registry.ModItems;
import coffeecatrailway.coffeecheese.registry.ModParticles;
import coffeecatrailway.coffeecheese.registry.ModRecipes;
import coffeecatrailway.coffeecheese.registry.ModStats;
import coffeecatrailway.coffeecheese.registry.ModTileEntities;
import coffeecatrailway.coffeecheese.registry.ModVanillaCompat;
import com.mojang.brigadier.CommandDispatcher;
import com.mrcrayfish.filters.Filters;
import io.netty.buffer.Unpooled;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.BreakingParticle;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="coffeecheese")
public class CheeseMod {
    public static final String MOD_ID = "coffeecheese";
    public static final Logger LOGGER = LogManager.getLogger((String)"coffeecheese");
    public static ModCheeseConfig.ClientConfig CLIENT_CFG;
    public static ModCheeseConfig.ServerConfig SERVER_CFG;

    public CheeseMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setupClient);
        modEventBus.addListener(this::setupCommon);
        modEventBus.addListener(this::interModEvent);
        Pair specPairC = new ForgeConfigSpec.Builder().configure(ModCheeseConfig.ClientConfig::new);
        Pair specPairS = new ForgeConfigSpec.Builder().configure(ModCheeseConfig.ServerConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPairC.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)specPairS.getRight());
        CLIENT_CFG = (ModCheeseConfig.ClientConfig)specPairC.getLeft();
        SERVER_CFG = (ModCheeseConfig.ServerConfig)specPairS.getLeft();
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModFluids.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModBiomes.BIOMES.register(modEventBus);
        modEventBus.addListener(ModStats::registerAll);
        ModRecipes.registerRecipeType();
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        modEventBus.addListener(ModEntities::registerSpawnPlacements);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModDimensions.DIMENSIONS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
    }

    public void interModEvent(InterModProcessEvent event) {
        if (ModList.get().isLoaded("jeresources")) {
            JEResourcesCompat.register();
        }
    }

    public void setupClient(FMLClientSetupEvent event) {
        ModContainers.registerScreens();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CheeseMod::registerParticleFactories);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CheeseMod::registerEntityRenderers);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CheeseMod::registerTileEntityRenderers);
        LOGGER.debug("Client setup - Renderers");
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CheeseMod::registerFilters);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFilters() {
        if (ModList.get().isLoaded("filters")) {
            Filters.get().register(ModItemGroups.GROUP_ALL, CheeseMod.getLocation("filters/all/natural"), new ItemStack((IItemProvider)ModBlocks.CHEESE_SAPLING.get()));
            Filters.get().register(ModItemGroups.GROUP_ALL, CheeseMod.getLocation("filters/all/woods"), new ItemStack((IItemProvider)ModBlocks.CHEESE_LOG.get()));
            Filters.get().register(ModItemGroups.GROUP_ALL, CheeseMod.getLocation("filters/all/minerals"), new ItemStack((IItemProvider)ModBlocks.CHEESE_METAL_BLOCK.get()));
            Filters.get().register(ModItemGroups.GROUP_ARMOR_TOOLS, CheeseMod.getLocation("filters/armor_tools/weapons"), new ItemStack((IItemProvider)ModItems.CHEESE_METAL_SWORD.get()));
            Filters.get().register(ModItemGroups.GROUP_ARMOR_TOOLS, CheeseMod.getLocation("filters/armor_tools/tools"), new ItemStack((IItemProvider)ModItems.CHEESE_METAL_AXE.get()));
            Filters.get().register(ModItemGroups.GROUP_ARMOR_TOOLS, CheeseMod.getLocation("filters/armor_tools/armor"), new ItemStack((IItemProvider)ModItems.CHEESE_METAL_CHESTPLATE.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/cheese"), new ItemStack((IItemProvider)ModItems.CHEESE_SLICE.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/raw"), new ItemStack((IItemProvider)ModItems.HAM_RAW.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/cooked"), new ItemStack((IItemProvider)ModItems.HAM_COOKED.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/toasties"), new ItemStack((IItemProvider)ModItems.TOASTIE_CHEESE.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/pizzas"), new ItemStack((IItemProvider)ModItems.PIZZA_CHEESE.get()));
            Filters.get().register(ModItemGroups.GROUP_FOODS, CheeseMod.getLocation("filters/foods/crackers"), new ItemStack((IItemProvider)ModItems.CRACKER.get()));
            LOGGER.debug("Common setup - MrCrayfish Filters support");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerParticleFactories() {
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.ITEM_CHEESE_BALL.get(), (type, world, v, v1, v2, v3, v4, v5) -> new BreakingParticle(world, v, v1, v2, new ItemStack((IItemProvider)ModItems.CHEESE_BALL.get())));
        LOGGER.debug("Particles");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers() {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler(CheeseBallEntity.class, manager -> new SpriteRenderer(manager, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler(CheeseFoodie.class, manager -> new FoodieRenderer(manager, CheeseMod.getLocation("textures/entity/foodie/cheese.png")));
        RenderingRegistry.registerEntityRenderingHandler(GrilledCheeseFoodie.class, manager -> new FoodieRenderer(manager, CheeseMod.getLocation("textures/entity/foodie/grilled_cheese.png")));
        RenderingRegistry.registerEntityRenderingHandler(HamRawFoodie.class, manager -> new FoodieRenderer(manager, CheeseMod.getLocation("textures/entity/foodie/ham_raw.png")));
        RenderingRegistry.registerEntityRenderingHandler(HamCookedFoodie.class, manager -> new FoodieRenderer(manager, CheeseMod.getLocation("textures/entity/foodie/ham_cooked.png")));
        RenderingRegistry.registerEntityRenderingHandler(BoatEntityCM.class, BoatRendererCM::new);
        LOGGER.debug("Entity renderers");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(GrillTileEntity.class, (TileEntityRenderer)new GrillTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(MelterTileEntity.class, (TileEntityRenderer)new MelterTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(PizzaOvenTileEntity.class, (TileEntityRenderer)new PizzaOvenTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(FoodWorldPortalTileEntity.class, (TileEntityRenderer)new FoodWorldPortalTileEntityRenderer());
        LOGGER.debug("Tile entity renderers");
    }

    public void setupCommon(FMLCommonSetupEvent event) {
        ModBiomes.addBiomeTypes();
        ModBiomes.addBiomeFeatures();
        ModWorldFeatures.addFeatures();
        ModVanillaCompat.setup();
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompatibility::new);
        }
        LOGGER.debug("Common setup");
    }

    public static boolean isDate(int month, int day) {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        int curentMonth = cal.get(2);
        int curentDay = cal.get(5);
        boolean inRange = curentDay == day;
        return curentMonth == month && inRange;
    }

    public static ResourceLocation getLocation(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static float map(float from, float fromMin, float fromMax, float toMin, float toMax) {
        float fromAbs = from - fromMin;
        float fromMaxAbs = fromMax - fromMin;
        float normal = fromAbs / fromMaxAbs;
        float toMaxAbs = toMax - toMin;
        float toAbs = toMaxAbs * normal;
        return toAbs + toMin;
    }

    @Mod.EventBusSubscriber(modid="coffeecheese", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventBus {
        @SubscribeEvent
        public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
            if (event.getCrafting().func_77973_b() == ModFluids.OIL_BUCKET.get()) {
                event.getInventory().func_70298_a(ForgeEventBus.getSlotFor(event, new ItemStack((IItemProvider)Items.field_151131_as)), 1);
            }
        }

        private static int getSlotFor(PlayerEvent.ItemCraftedEvent event, ItemStack stack) {
            for (int i = 0; i < event.getInventory().func_70302_i_(); ++i) {
                if (event.getInventory().func_70301_a(i).func_190926_b() || !ForgeEventBus.stackEqualExact(stack, event.getInventory().func_70301_a(i))) continue;
                return i;
            }
            return -1;
        }

        private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
        }

        @SubscribeEvent
        public static void onBlockBroken(BlockEvent.BreakEvent event) {
            if (!(event.getWorld().func_201670_d() || event.getPlayer().func_184614_ca().func_77973_b() == Items.field_151097_aZ && event.getPlayer().func_184812_l_() || event.getState().func_177230_c() != Blocks.field_150349_c && event.getState().func_177230_c() != Blocks.field_196804_gh && event.getState().func_177230_c() != Blocks.field_196554_aH || !(Math.random() <= (double)((Integer)ModCheeseConfig.pineappleDropChance.get()).intValue() / 100.0))) {
                event.getWorld().func_180501_a(event.getPos(), Blocks.field_150350_a.func_176223_P(), 2);
                event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)ModItems.PINEAPPLE_PLANT.get(), 1)));
            }
        }

        @SubscribeEvent
        public static void serverStarting(FMLServerStartingEvent event) {
            ChezCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
            LOGGER.debug("Command registered");
        }

        @SubscribeEvent
        public static void registerToManager(RegisterDimensionsEvent event) {
            ResourceLocation location = CheeseMod.getLocation("foodworld");
            if (DimensionType.func_193417_a((ResourceLocation)location) == null) {
                ModDimensions.FOOD_WORLD_TYPE = DimensionManager.registerDimension((ResourceLocation)location, (ModDimension)((ModDimension)ModDimensions.FOOD_WORLD.get()), (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
                DimensionManager.keepLoaded((DimensionType)ModDimensions.FOOD_WORLD_TYPE, (boolean)false);
            } else {
                ModDimensions.FOOD_WORLD_TYPE = DimensionType.func_193417_a((ResourceLocation)location);
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            if (!(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld world = (ServerWorld)event.getWorld();
            if (world.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ || world.field_73011_w.func_186058_p() == ModDimensions.FOOD_WORLD_TYPE) {
                ModDimensions.FOOD_WORLD_TELEPORTER = new FoodWorldTeleporter(world);
                world.customTeleporters.add(ModDimensions.FOOD_WORLD_TELEPORTER);
            }
        }
    }
}

