/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModCheeseConfig {
    private static final String config = "coffeecheese.";
    private static final String configModifier = "coffeecheese.modifier.";
    private static final String configOres = "coffeecheese.ores.";
    private static final String configMobs = "coffeecheese.mobs.";
    public static ForgeConfigSpec.DoubleValue cheeseSuitScale;
    public static ForgeConfigSpec.DoubleValue cheeseSuitBindingScale;
    public static ForgeConfigSpec.DoubleValue hamSuitScale;
    public static ForgeConfigSpec.DoubleValue hamSuitBindingScale;
    public static ForgeConfigSpec.BooleanValue topEnabled;
    public static ForgeConfigSpec.BooleanValue stickyFoodBlock;
    public static ForgeConfigSpec.IntValue pineappleDropChance;
    public static ForgeConfigSpec.DoubleValue grilledFoodMultiplier;
    public static ForgeConfigSpec.DoubleValue foodCombo;
    public static ForgeConfigSpec.IntValue grillSpeed;
    public static ForgeConfigSpec.IntValue melterSpeed;
    public static ForgeConfigSpec.IntValue pizzaOvenSpeed;
    public static ForgeConfigSpec.BooleanValue cheeseOreNetherGen;
    public static ForgeConfigSpec.IntValue cheeseOreNetherSize;
    public static ForgeConfigSpec.IntValue cheeseOreNetherRegionSize;
    public static ForgeConfigSpec.BooleanValue cheeseOreEndGen;
    public static ForgeConfigSpec.IntValue cheeseOreEndSize;
    public static ForgeConfigSpec.IntValue cheeseOreEndRegionSize;
    public static ForgeConfigSpec.IntValue cheeseOreSize;
    public static ForgeConfigSpec.IntValue cheeseOreRegionSize;
    public static ForgeConfigSpec.BooleanValue grilledCheeseOreNetherGen;
    public static ForgeConfigSpec.IntValue grilledCheeseOreNetherSize;
    public static ForgeConfigSpec.IntValue grilledCheeseOreNetherRegionSize;
    public static ForgeConfigSpec.BooleanValue grilledCheeseOreEndGen;
    public static ForgeConfigSpec.IntValue grilledCheeseOreEndSize;
    public static ForgeConfigSpec.IntValue grilledCheeseOreEndRegionSize;
    public static ForgeConfigSpec.IntValue grilledCheeseOreSize;
    public static ForgeConfigSpec.IntValue grilledCheeseOreRegionSize;
    public static ForgeConfigSpec.BooleanValue hamRawOreNetherGen;
    public static ForgeConfigSpec.IntValue hamRawOreNetherSize;
    public static ForgeConfigSpec.IntValue hamRawOreNetherRegionSize;
    public static ForgeConfigSpec.BooleanValue hamRawOreEndGen;
    public static ForgeConfigSpec.IntValue hamRawOreEndSize;
    public static ForgeConfigSpec.IntValue hamRawOreEndRegionSize;
    public static ForgeConfigSpec.IntValue hamRawOreSize;
    public static ForgeConfigSpec.IntValue hamRawOreRegionSize;
    public static ForgeConfigSpec.BooleanValue hamCookedOreNetherGen;
    public static ForgeConfigSpec.IntValue hamCookedOreNetherSize;
    public static ForgeConfigSpec.IntValue hamCookedOreNetherRegionSize;
    public static ForgeConfigSpec.BooleanValue hamCookedOreEndGen;
    public static ForgeConfigSpec.IntValue hamCookedOreEndSize;
    public static ForgeConfigSpec.IntValue hamCookedOreEndRegionSize;
    public static ForgeConfigSpec.IntValue hamCookedOreSize;
    public static ForgeConfigSpec.IntValue hamCookedOreRegionSize;
    public static ForgeConfigSpec.IntValue cheeseFoodieWeight;
    public static ForgeConfigSpec.IntValue cheeseFoodieMin;
    public static ForgeConfigSpec.IntValue cheeseFoodieMax;
    public static ForgeConfigSpec.IntValue grilledCheeseFoodieWeight;
    public static ForgeConfigSpec.IntValue grilledCheeseFoodieMin;
    public static ForgeConfigSpec.IntValue grilledCheeseFoodieMax;
    public static ForgeConfigSpec.IntValue hamRawFoodieWeight;
    public static ForgeConfigSpec.IntValue hamRawFoodieMin;
    public static ForgeConfigSpec.IntValue hamRawFoodieMax;
    public static ForgeConfigSpec.IntValue hamCookedFoodieWeight;
    public static ForgeConfigSpec.IntValue hamCookedFoodieMin;
    public static ForgeConfigSpec.IntValue hamCookedFoodieMax;

    public static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            stickyFoodBlock = builder.comment("If true all food blocks (cheese, grilled cheese & ham raw or cooked) will act like slime blocks when pushed by a piston").define("coffeecheese.stickyFoodBlock", true);
            pineappleDropChance = builder.comment("Chance for a pineapple plant to drop from tall grass").defineInRange("coffeecheese.pineappleDropChance", 8, 0, 100);
            builder.comment("\nCheeseMod modifier settings");
            grilledFoodMultiplier = builder.comment("The amount of how much the saturation changes when grilled").defineInRange("coffeecheese.modifier.grilledSaturation", 1.5, 0.5, 10.0);
            foodCombo = builder.comment("Food combo add amount (pizza, toastie, etc.)").defineInRange("coffeecheese.modifier.foodCombo", 1.25, 0.5, 5.0);
            int minSpeed = 1;
            int maxSpeed = 20;
            grillSpeed = builder.comment("Speed multiplier for the grill").defineInRange("coffeecheese.modifier.grillSpeed", 5, minSpeed, maxSpeed);
            melterSpeed = builder.comment("Speed multiplier for the melter").defineInRange("coffeecheese.modifier.melterSpeed", 4, minSpeed, maxSpeed);
            pizzaOvenSpeed = builder.comment("Speed multiplier for the pizza oven").defineInRange("coffeecheese.modifier.pizzaOvenSpeed", 4, minSpeed, maxSpeed);
            builder.comment("\nCheeseMod ore settings");
            cheeseOreNetherGen = builder.comment("Cheese metal ore (nether)").define("coffeecheese.ores.nether.cheeseOreGen", true);
            cheeseOreNetherSize = builder.defineInRange("coffeecheese.ores.nether.cheeseOreSize", 10, 0, 100);
            cheeseOreNetherRegionSize = builder.defineInRange("coffeecheese.ores.nether.cheeseOreRegionSize", 8, 0, 100);
            cheeseOreEndGen = builder.comment("Cheese metal ore (end)").define("coffeecheese.ores.end.cheeseOreGen", true);
            cheeseOreEndSize = builder.defineInRange("coffeecheese.ores.end.cheeseOreSize", 10, 0, 100);
            cheeseOreEndRegionSize = builder.defineInRange("coffeecheese.ores.end.cheeseOreRegionSize", 8, 0, 100);
            cheeseOreSize = builder.comment("Cheese metal ore (overworld)").defineInRange("coffeecheese.ores.cheeseOreSize", 10, 0, 100);
            cheeseOreRegionSize = builder.defineInRange("coffeecheese.ores.cheeseOreRegionSize", 8, 0, 100);
            grilledCheeseOreNetherGen = builder.comment("Grilled cheese metal ore (nether)").define("coffeecheese.ores.nether.grilledCheeseOreGen", true);
            grilledCheeseOreNetherSize = builder.defineInRange("coffeecheese.ores.nether.grilledCheeseOreSize", 10, 0, 100);
            grilledCheeseOreNetherRegionSize = builder.defineInRange("coffeecheese.ores.nether.grilledCheeseOreRegionSize", 8, 0, 100);
            grilledCheeseOreEndGen = builder.comment("Grilled cheese metal ore (end)").define("coffeecheese.ores.end.grilledCheeseOreGen", true);
            grilledCheeseOreEndSize = builder.defineInRange("coffeecheese.ores.end.grilledCheeseOreSize", 10, 0, 100);
            grilledCheeseOreEndRegionSize = builder.defineInRange("coffeecheese.ores.end.grilledCheeseOreRegionSize", 8, 0, 100);
            grilledCheeseOreSize = builder.comment("Grilled cheese metal ore (overworld)").defineInRange("coffeecheese.ores.grilledCheeseOreSize", 10, 0, 100);
            grilledCheeseOreRegionSize = builder.defineInRange("coffeecheese.ores.grilledCheeseOreRegionSize", 8, 0, 100);
            hamRawOreNetherGen = builder.comment("Ham raw metal ore (nether)").define("coffeecheese.ores.nether.hamRawOreGen", true);
            hamRawOreNetherSize = builder.defineInRange("coffeecheese.ores.nether.hamRawOreSize", 10, 0, 100);
            hamRawOreNetherRegionSize = builder.defineInRange("coffeecheese.ores.nether.hamRawOreRegionSize", 8, 0, 100);
            hamRawOreEndGen = builder.comment("Ham raw metal ore (end)").define("coffeecheese.ores.end.hamRawOreGen", true);
            hamRawOreEndSize = builder.defineInRange("coffeecheese.ores.end.hamRawOreSize", 10, 0, 100);
            hamRawOreEndRegionSize = builder.defineInRange("coffeecheese.ores.end.hamRawOreRegionSize", 8, 0, 100);
            hamRawOreSize = builder.comment("Ham raw metal ore (overworld)").defineInRange("coffeecheese.ores.hamRawOreSize", 10, 0, 100);
            hamRawOreRegionSize = builder.defineInRange("coffeecheese.ores.hamRawOreRegionSize", 8, 0, 100);
            hamCookedOreNetherGen = builder.comment("Ham cooked metal ore (nether)").define("coffeecheese.ores.nether.hamCookedOreGen", true);
            hamCookedOreNetherSize = builder.defineInRange("coffeecheese.ores.nether.hamCookedOreSize", 10, 0, 100);
            hamCookedOreNetherRegionSize = builder.defineInRange("coffeecheese.ores.nether.hamCookedOreRegionSize", 8, 0, 100);
            hamCookedOreEndGen = builder.comment("Ham cooked metal ore (end)").define("coffeecheese.ores.end.hamCookedOreGen", true);
            hamCookedOreEndSize = builder.defineInRange("coffeecheese.ores.end.hamCookedOreSize", 10, 0, 100);
            hamCookedOreEndRegionSize = builder.defineInRange("coffeecheese.ores.end.hamCookedOreRegionSize", 8, 0, 100);
            hamCookedOreSize = builder.comment("Ham cooked metal ore (overworld)").defineInRange("coffeecheese.ores.hamCookedOreSize", 10, 0, 100);
            hamCookedOreRegionSize = builder.defineInRange("coffeecheese.ores.hamCookedOreRegionSize", 8, 0, 100);
            builder.comment("\nCheeseMod mob settings");
            cheeseFoodieWeight = builder.comment("Cheese foodie weight").defineInRange("coffeecheese.mobs.cheeseFoodieWeight", 100, 0, 100);
            cheeseFoodieMin = builder.comment("Cheese foodie min count").defineInRange("coffeecheese.mobs.cheeseFoodieMin", 1, 0, 10);
            cheeseFoodieMax = builder.comment("Cheese foodie max count").defineInRange("coffeecheese.mobs.cheeseFoodieMax", 5, 1, 10);
            grilledCheeseFoodieWeight = builder.comment("Grilled cheese foodie weight").defineInRange("coffeecheese.mobs.grilledCheeseFoodieWeight", 100, 0, 100);
            grilledCheeseFoodieMin = builder.comment("Grilled cheese foodie min count").defineInRange("coffeecheese.mobs.grilledCheeseFoodieMin", 1, 0, 10);
            grilledCheeseFoodieMax = builder.comment("Grilled cheese foodie max count").defineInRange("coffeecheese.mobs.grilledCheeseFoodieMax", 5, 1, 10);
            hamRawFoodieWeight = builder.comment("Ham raw foodie weight").defineInRange("coffeecheese.mobs.hamRawFoodieWeight", 100, 0, 100);
            hamRawFoodieMin = builder.comment("Ham raw foodie min count").defineInRange("coffeecheese.mobs.hamRawFoodieMin", 1, 0, 10);
            hamRawFoodieMax = builder.comment("Ham raw foodie max count").defineInRange("coffeecheese.mobs.hamRawFoodieMax", 5, 1, 10);
            hamCookedFoodieWeight = builder.comment("Ham cooked foodie weight").defineInRange("coffeecheese.mobs.hamCookedFoodieWeight", 100, 0, 100);
            hamCookedFoodieMin = builder.comment("Ham cooked foodie min count").defineInRange("coffeecheese.mobs.hamCookedFoodieMin", 1, 0, 10);
            hamCookedFoodieMax = builder.comment("Ham cooked foodie max count").defineInRange("coffeecheese.mobs.hamCookedFoodieMax", 5, 1, 10);
        }
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            double minScale = 0.0;
            double maxScale = 10.0;
            cheeseSuitScale = builder.comment("Cheese suit scale").defineInRange("coffeecheese.modifier.cheeseSuitScale", 0.4, minScale, maxScale);
            cheeseSuitBindingScale = builder.comment("Cheese suit binding scale").defineInRange("coffeecheese.modifier.cheeseSuitBindingScale", 0.3, minScale, maxScale);
            hamSuitScale = builder.comment("Ham suit scale").defineInRange("coffeecheese.modifier.hamSuitScale", 0.6, minScale, maxScale);
            hamSuitBindingScale = builder.comment("Ham suit binding scale").defineInRange("coffeecheese.modifier.hamSuitBindingScale", 0.3, minScale, maxScale);
            topEnabled = builder.comment("Use the one probe").define("coffeecheese.topEnabled", true);
        }
    }
}

