/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.client.gui.screen;

import coffeecatrailway.coffeecheese.CheeseMod;
import coffeecatrailway.coffeecheese.client.gui.container.MelterContainer;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MelterScreen
extends ContainerScreen<MelterContainer> {
    public static final ResourceLocation GUI_TEXTURE = CheeseMod.getLocation("textures/gui/container/melter.png");

    public MelterScreen(MelterContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int i = this.field_147003_i + 97;
        int j = this.field_147009_r + 8;
        if (mouseX >= i && mouseX <= i + 34 && mouseY >= j && mouseY <= j + 64) {
            this.renderTooltip(MelterScreen.getFormatedFluidString((Fluid)Registry.field_212619_h.func_148745_a(((MelterContainer)this.field_147002_h).getFluid()), ((MelterContainer)this.field_147002_h).getFluidAmount()), mouseX, mouseY);
        }
    }

    public static String getFormatedFluidString(Fluid fluid, int amount) {
        String fluidName = I18n.func_135052_a((String)("block." + fluid.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0]);
        if (fluidName.contains("empty")) {
            fluidName = "Empty";
        }
        return I18n.func_135052_a((String)"gui.coffeecheese.category.melter.fluid", (Object[])new Object[]{fluidName, amount, 10000});
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.title.func_150254_d();
        this.font.func_211126_b(title, (float)(this.field_146999_f / 2 - this.font.func_78256_a(title) / 2) - 9.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 4), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((MelterContainer)this.field_147002_h).isBurning()) {
            int k = ((MelterContainer)this.field_147002_h).getBurnLeftScaled();
            this.blit(i + 44, j + 34 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        int l = ((MelterContainer)this.field_147002_h).getCookProgressionScaled();
        this.blit(i + 68, j + 32, 176, 14, l + 1, 16);
        Fluid fluid = (Fluid)Registry.field_212619_h.func_148745_a(((MelterContainer)this.field_147002_h).getFluid());
        int color = ((MelterContainer)this.field_147002_h).getFluidColor();
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        GlStateManager.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        ResourceLocation fluidTexture = MelterScreen.getFluidTexture(fluid);
        if (fluidTexture != null) {
            GlStateManager.enableBlend();
            this.minecraft.func_110434_K().func_110577_a(fluidTexture);
            int k = (int)MelterScreen.mapFluid(((MelterContainer)this.field_147002_h).getFluidAmount(), 0.0f, 64.0f);
            int h = MelterScreen.getFluidTextureHeight(fluidTexture);
            h = (int)((float)(h * h) * 1.5f);
            MelterScreen.blit((int)(i + 97), (int)(j + 8 + 64 - k), (float)0.0f, (float)(64 - k + 1), (int)32, (int)k, (int)16, (int)h);
            GlStateManager.disableBlend();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(i + 97, j + 8, 176, 32, 32, 64);
    }

    public static float mapFluid(float amount, float min, float max) {
        return CheeseMod.map(amount, 0.0f, 10000.0f, min, max);
    }

    public static int getFluidTextureHeight(ResourceLocation fluidTexture) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(fluidTexture);
        return sprite.func_94216_b();
    }

    public static ResourceLocation getFluidTexture(Fluid fluid) {
        ResourceLocation fluidTexture = fluid.getAttributes().getStillTexture();
        if (fluidTexture != null) {
            return new ResourceLocation(fluidTexture.func_110624_b(), "textures/" + fluidTexture.func_110623_a() + ".png");
        }
        return null;
    }
}

