/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.block;

import coffeecatrailway.coffeecheese.common.tileentity.FoodDrawTileEntity;
import coffeecatrailway.coffeecheese.util.VoxelShapeHelper;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FoodDrawBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape[] SHAPE_DETAILS = new VoxelShape[]{Block.func_208617_a((double)1.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0), Block.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)14.0), Block.func_208617_a((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)7.0, (double)2.0), Block.func_208617_a((double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)6.0, (double)1.0), Block.func_208617_a((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0), Block.func_208617_a((double)5.0, (double)10.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0)};
    private static final VoxelShape SHAPE_BASE = VoxelShapeHelper.combineAll(Lists.newArrayList((Object[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.func_208617_a((double)13.0, (double)1.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0)}));
    private IFoodStat stat;

    public FoodDrawBlock(Block.Properties properties, IFoodStat stat) {
        super(properties);
        this.stat = stat;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape detailsRot = SHAPE_DETAILS[0];
        for (VoxelShape shape : SHAPE_DETAILS) {
            int index;
            switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                default: {
                    index = 3;
                    break;
                }
                case EAST: {
                    index = 0;
                    break;
                }
                case SOUTH: {
                    index = 1;
                    break;
                }
                case WEST: {
                    index = 2;
                }
            }
            detailsRot = VoxelShapeHelper.combineAll(Lists.newArrayList((Object[])new VoxelShape[]{detailsRot, VoxelShapeHelper.getRotatedShapes(shape)[index]}));
        }
        return VoxelShapes.func_197872_a((VoxelShape)SHAPE_BASE, (VoxelShape)detailsRot);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof FoodDrawTileEntity) {
            ((FoodDrawTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return true;
        }
        INamedContainerProvider provider = this.func_220052_b(state, world, pos);
        if (provider != null) {
            player.func_213829_a(provider);
            player.func_195066_a(this.stat.getStat());
        }
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new FoodDrawTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return super.func_180641_l(state, world, pos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public static interface IFoodStat {
        public ResourceLocation getStat();
    }
}

