/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.block;

import coffeecatrailway.coffeecheese.common.ModTags;
import coffeecatrailway.coffeecheese.common.tileentity.FoodWorldPortalTileEntity;
import coffeecatrailway.coffeecheese.common.world.dimension.FoodWorldTeleporter;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModDimensions;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class FoodWorldPortalBlock
extends ContainerBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NULL = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public FoodWorldPortalBlock(Block.Properties properties) {
        super(properties);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new FoodWorldPortalTileEntity();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        Size size = this.isPortal((IWorld)world, pos);
        System.out.println(world.func_180495_p(pos).func_177230_c());
        System.out.println(size);
        if (size != null && this.canCreatePortalByWorld(world)) {
            size.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world) {
        return world.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ || world.field_73011_w.func_186058_p() == ModDimensions.FOOD_WORLD_TYPE;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size size = new Size(world, pos);
        if (size.isValid()) {
            return size;
        }
        Size size1 = new Size(world, pos);
        return size1.isValid() ? size1 : null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return facingState.func_177230_c() != this && !new Size(world, pos).isValid() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (!worldIn.field_72995_K && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            MinecraftServer server = worldIn.func_73046_m();
            if (entityIn.field_71093_bK.getModType() == ModDimensions.FOOD_WORLD.get()) {
                if (server != null && entityIn.field_71088_bW <= 0) {
                    DimensionType warptype = DimensionType.field_223227_a_;
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                    if (entityIn.field_71088_bW > 0) {
                        entityIn.field_71088_bW = entityIn.func_82147_ab();
                    }
                    if (entityIn instanceof ServerPlayerEntity) {
                        this.changePlayerDimension(warptype, (ServerPlayerEntity)entityIn);
                        entityIn.field_71088_bW = entityIn.func_82147_ab();
                    } else {
                        this.changeDimension(warptype, entityIn);
                        entityIn.field_71088_bW = entityIn.func_82147_ab();
                    }
                } else {
                    entityIn.field_71088_bW = Math.max(entityIn.func_82147_ab(), 100);
                }
            } else if (server != null && entityIn.field_71088_bW <= 0) {
                DimensionType warptype = ModDimensions.FOOD_WORLD_TYPE;
                entityIn.field_71088_bW = entityIn.func_82147_ab();
                if (entityIn.field_71088_bW > 0) {
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                }
                if (entityIn instanceof ServerPlayerEntity) {
                    this.changePlayerDimension(warptype, (ServerPlayerEntity)entityIn);
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                } else {
                    this.changeDimension(warptype, entityIn);
                    entityIn.field_71088_bW = entityIn.func_82147_ab();
                }
            } else {
                entityIn.field_71088_bW = Math.max(entityIn.func_82147_ab(), 100);
            }
        }
    }

    public Entity changePlayerDimension(DimensionType destination, ServerPlayerEntity serverPlayerEntity) {
        float f1;
        if (!ForgeHooks.onTravelToDimension((Entity)serverPlayerEntity, (DimensionType)destination)) {
            return null;
        }
        serverPlayerEntity.field_184851_cj = true;
        DimensionType dimensiontype = serverPlayerEntity.field_71093_bK;
        ServerWorld serverworld = serverPlayerEntity.field_71133_b.func_71218_a(dimensiontype);
        serverPlayerEntity.field_71093_bK = destination;
        ServerWorld serverworld1 = serverPlayerEntity.field_71133_b.func_71218_a(destination);
        FoodWorldTeleporter teleporter = new FoodWorldTeleporter(serverworld1);
        WorldInfo worldinfo = serverPlayerEntity.field_70170_p.func_72912_H();
        serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), serverPlayerEntity.field_71134_c.func_73081_b()));
        serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = serverPlayerEntity.field_71133_b.func_184103_al();
        playerlist.func_187243_f(serverPlayerEntity);
        serverworld.removeEntity((Entity)serverPlayerEntity, true);
        serverPlayerEntity.revive();
        double d0 = serverPlayerEntity.field_70165_t;
        double d1 = serverPlayerEntity.field_70163_u;
        double d2 = serverPlayerEntity.field_70161_v;
        float f = serverPlayerEntity.field_70125_A;
        float f2 = f1 = serverPlayerEntity.field_70177_z;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverworld1.func_201675_m().getMovementFactor();
        serverPlayerEntity.func_70012_b(d0 *= moveFactor, d1, d2 *= moveFactor, f1, f);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        double d7 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, serverworld1.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, serverworld1.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        serverPlayerEntity.func_70012_b(d0, d1, d2, f1, f);
        if (!teleporter.func_222268_a((Entity)serverPlayerEntity, f2)) {
            teleporter.func_85188_a((Entity)serverPlayerEntity);
            teleporter.func_222268_a((Entity)serverPlayerEntity, f2);
        }
        serverworld.func_217381_Z().func_76319_b();
        serverPlayerEntity.func_70029_a((World)serverworld1);
        serverworld1.func_217447_b(serverPlayerEntity);
        serverPlayerEntity.field_71135_a.func_147364_a(serverPlayerEntity.field_70165_t, serverPlayerEntity.field_70163_u, serverPlayerEntity.field_70161_v, f1, f);
        serverPlayerEntity.field_71134_c.func_73080_a(serverworld1);
        serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(serverPlayerEntity.field_71075_bZ));
        playerlist.func_72354_b(serverPlayerEntity, serverworld1);
        playerlist.func_72385_f(serverPlayerEntity);
        for (EffectInstance effectinstance : serverPlayerEntity.func_70651_bq()) {
            serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(serverPlayerEntity.func_145782_y(), effectinstance));
        }
        serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        serverPlayerEntity.field_71144_ck = -1;
        serverPlayerEntity.field_71149_ch = -1.0f;
        serverPlayerEntity.field_71146_ci = -1;
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)serverPlayerEntity, (DimensionType)dimensiontype, (DimensionType)destination);
        return serverPlayerEntity;
    }

    @Nullable
    public Entity changeDimension(DimensionType destination, Entity entity) {
        if (!entity.field_70170_p.field_72995_K && !entity.field_70128_L) {
            entity.field_70170_p.func_217381_Z().func_76320_a("changeDimension");
            MinecraftServer minecraftserver = entity.func_184102_h();
            DimensionType dimensiontype = entity.field_71093_bK;
            ServerWorld serverworld = minecraftserver.func_71218_a(dimensiontype);
            ServerWorld serverworld1 = minecraftserver.func_71218_a(destination);
            FoodWorldTeleporter teleporter = new FoodWorldTeleporter(serverworld1);
            entity.field_71093_bK = destination;
            entity.func_213319_R();
            entity.field_70170_p.func_217381_Z().func_76320_a("reposition");
            Vec3d vec3d = entity.func_213322_ci();
            entity.field_70170_p.func_217381_Z().func_219895_b("reloading");
            Entity entity2 = entity.func_200600_R().func_200721_a((World)serverworld1);
            if (entity2 != null) {
                entity2.func_180432_n(entity);
                teleporter.func_222268_a(entity2, entity2.field_70177_z);
                entity2.func_213317_d(vec3d);
                serverworld1.func_217460_e(entity2);
                entity.func_70106_y();
            }
            entity2.field_70170_p.func_217381_Z().func_76319_b();
            serverworld.func_82742_i();
            serverworld1.func_82742_i();
            entity2.field_70170_p.func_217381_Z().func_76319_b();
            return entity2;
        }
        return null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return NULL;
    }

    public static class Size {
        private static final int MAX_SIZE = 9;
        private static final int MIN_SIZE = 3;
        private final IWorld world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;

        public Size(IWorld world, BlockPos pos) {
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, Direction.EAST);
            int west = this.getDistanceUntilEdge(pos, Direction.WEST);
            int north = this.getDistanceUntilEdge(pos, Direction.NORTH);
            int south = this.getDistanceUntilEdge(pos, Direction.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 9 || length > 9) {
                return;
            }
            if (width < 3 || length < 3) {
                return;
            }
            BlockPos nwCorner = pos.func_177985_f(west).func_177964_d(north);
            BlockPos seCorner = pos.func_177965_g(east).func_177970_e(south);
            this.nw = nwCorner.func_177982_a(1, 0, 1);
            this.se = seCorner.func_177982_a(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            for (int y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if (y != 0 && x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1 || this.isFrameBlock(world.func_180495_p(nwCorner.func_177977_b().func_177982_a(x, y, z)))) continue;
                        return;
                    }
                }
            }
            this.valid = true;
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.isFrameBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            BlockState state = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return this.isFrameBlock(state) ? i : 0;
        }

        private boolean isEmptyBlock(BlockState state) {
            return state.func_196958_f();
        }

        private boolean isFrameBlock(BlockState state) {
            return ModTags.Blocks.FOOD_BLOCKS.func_199685_a_((Object)state.func_177230_c());
        }

        private boolean isValid() {
            return this.valid;
        }

        private void placePortalBlocks() {
            for (BlockPos portalPos : BlockPos.MutableBlockPos.func_218278_a((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.func_180501_a(portalPos, ((FoodWorldPortalBlock)ModBlocks.FOOD_PORTAL.get()).func_176223_P(), 2);
            }
        }
    }
}

