/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.block;

import coffeecatrailway.coffeecheese.common.tileentity.GrillTileEntity;
import coffeecatrailway.coffeecheese.registry.ModFluids;
import coffeecatrailway.coffeecheese.registry.ModItems;
import coffeecatrailway.coffeecheese.registry.ModStats;
import coffeecatrailway.coffeecheese.util.VoxelShapeHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GrillBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty HAS_CATCHER = BooleanProperty.func_177716_a((String)"has_catcher");
    private static final VoxelShape SHAPE_BASE = VoxelShapeHelper.combineAll(Lists.newArrayList((Object[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)11.0, (double)2.0), Block.func_208617_a((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)2.0), Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)11.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)11.0, (double)15.0), Block.func_208617_a((double)1.0, (double)11.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.func_208617_a((double)0.0, (double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.func_208617_a((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)1.0, (double)12.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.func_208617_a((double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0)}));
    private static final VoxelShape SHAPE_CATCHER = VoxelShapeHelper.combineAll(Lists.newArrayList((Object[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0), Block.func_208617_a((double)15.0, (double)7.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)1.0, (double)7.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0), Block.func_208617_a((double)1.0, (double)7.0, (double)14.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)1.0, (double)7.0, (double)2.0, (double)15.0, (double)8.0, (double)1.0)}));
    private static final VoxelShape SHAPE_BRASE_FRONT = Block.func_208617_a((double)15.0, (double)5.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE_BRASE_BACK = Block.func_208617_a((double)1.0, (double)5.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE_CONTROLS = Block.func_208617_a((double)16.0, (double)12.25, (double)2.5, (double)17.0, (double)14.25, (double)13.5);

    public GrillBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)HAS_CATCHER, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(SHAPE_BASE);
        if (((Boolean)state.func_177229_b((IProperty)HAS_CATCHER)).booleanValue()) {
            shapes.add(SHAPE_CATCHER);
        }
        Direction defaultDir = Direction.EAST;
        VoxelShape[] braseFront = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(SHAPE_BRASE_FRONT, defaultDir));
        VoxelShape[] braseBack = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(SHAPE_BRASE_BACK, defaultDir));
        VoxelShape[] controls = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(SHAPE_CONTROLS, defaultDir));
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        shapes.add(braseFront[facing.func_176736_b()]);
        shapes.add(braseBack[facing.func_176736_b()]);
        shapes.add(controls[facing.func_176736_b()]);
        return VoxelShapeHelper.combineAll(shapes);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, LIT, WATERLOGGED, HAS_CATCHER});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof GrillTileEntity) {
            ((GrillTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_184586_b(hand).func_77973_b() == ModFluids.OIL_BUCKET.get() && hand == Hand.MAIN_HAND) {
            GrillTileEntity tile;
            int oil;
            if (world.func_175625_s(pos) instanceof GrillTileEntity && (oil = (tile = (GrillTileEntity)world.func_175625_s(pos)).getTank().getFluidAmount()) <= 1000) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                tile.getTank().fill(new FluidStack((Fluid)ModFluids.OIL_S.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (player.func_184586_b(hand).func_77973_b() == Items.field_151133_ar && ((Boolean)state.func_177229_b((IProperty)HAS_CATCHER)).booleanValue() && hand == Hand.MAIN_HAND) {
            GrillTileEntity tile;
            int oil;
            if (world.func_175625_s(pos) instanceof GrillTileEntity && (oil = (tile = (GrillTileEntity)world.func_175625_s(pos)).getCatcherTank().getFluidAmount()) >= 1000) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)ModFluids.OIL_BUCKET.get()));
                }
                tile.getCatcherTank().drain(new FluidStack((Fluid)ModFluids.OIL_S.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (player.func_184586_b(hand).func_77973_b() == ModItems.OIL_CATCHER.get() && !((Boolean)state.func_177229_b((IProperty)HAS_CATCHER)).booleanValue() && hand == Hand.MAIN_HAND) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)HAS_CATCHER, (Comparable)Boolean.TRUE));
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_190918_g(1);
            }
        } else {
            INamedContainerProvider provider = this.func_220052_b(state, world, pos);
            if (provider != null) {
                player.func_213829_a(provider);
                player.func_195066_a(ModStats.INTERACT_WITH_GRILL);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new GrillTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return super.func_180641_l(state, world, pos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double d0 = pos.func_177958_n();
            double d1 = (double)pos.func_177956_o() + 1.0;
            double d2 = pos.func_177952_p();
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            double d3 = rand.nextDouble() * 0.9 + 0.1;
            double d4 = rand.nextDouble() * 0.9 + 0.1;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }
}

