/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class FoodieEntity
extends TameableEntity {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public FoodieEntity(EntityType<? extends TameableEntity> type, World world) {
        super(type, world);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187813_fI, 0.15f, 1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAngry(compound.func_74767_n("Angry"));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187813_fI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187807_fF;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && this.foodItem(itemstack) && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return true;
            }
            if (itemstack.func_190926_b() && player.func_70093_af()) {
                if (this.func_184187_bx() != null) {
                    this.func_184210_p();
                    return true;
                }
                if (this.func_184220_m((Entity)player)) {
                    return true;
                }
            }
            if (this.func_152114_e((LivingEntity)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.foodItem(itemstack) && !this.isAngry()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.breedingItem(stack);
    }

    public abstract boolean breedingItem(ItemStack var1);

    public abstract boolean foodItem(ItemStack var1);

    public abstract FoodieEntity createChild();

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    public FoodieEntity createChild(AgeableEntity entity) {
        FoodieEntity foodie = this.createChild();
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            foodie.func_184754_b(uuid);
            foodie.func_70903_f(true);
        }
        return foodie;
    }

    public boolean func_70878_b(AnimalEntity other) {
        if (other == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(other instanceof FoodieEntity)) {
            return false;
        }
        FoodieEntity foodie = (FoodieEntity)other;
        if (!foodie.func_70909_n()) {
            return false;
        }
        if (foodie.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && foodie.func_70880_s();
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        return target instanceof PlayerEntity && owner instanceof PlayerEntity && ((PlayerEntity)owner).func_96122_a((PlayerEntity)target);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.isAngry() && super.func_184652_a(player);
    }
}

