/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.item.crafting;

import coffeecatrailway.coffeecheese.common.item.crafting.GrillRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GrillRecipeSerializer<T extends GrillRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;
    private final int cookTime;

    public GrillRecipeSerializer(IFactory<T> factory, int cookTime) {
        this.factory = factory;
        this.cookTime = cookTime;
    }

    public T read(ResourceLocation id, JsonObject json) {
        ItemStack stack;
        JsonArray ingredientJson = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            stack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resultId = new ResourceLocation(result);
            stack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resultId).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.cookTime);
        int oil = JSONUtils.func_151208_a((JsonObject)json, (String)"oil", (int)0);
        return (T)((Object)((GrillRecipe)((Object)this.factory.create(id, ingredient, stack, experience, cookTime, oil))));
    }

    public T read(ResourceLocation id, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack stack = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int cookTime = buffer.func_150792_a();
        int oil = buffer.func_150792_a();
        return (T)((Object)((GrillRecipe)((Object)this.factory.create(id, ingredient, stack, experience, cookTime, oil))));
    }

    public void write(PacketBuffer buffer, T recipe) {
        ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buffer);
        buffer.func_150788_a(recipe.func_77571_b());
        buffer.writeFloat(recipe.func_222138_b());
        buffer.func_150787_b(recipe.func_222137_e());
        buffer.func_150787_b(((GrillRecipe)((Object)recipe)).getOil());
    }

    public static interface IFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, ItemStack var3, float var4, int var5, int var6);
    }
}

