/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.item.crafting;

import coffeecatrailway.coffeecheese.common.item.crafting.MelterRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MelterRecipeSerializer<T extends MelterRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;
    private final int cookTime;

    public MelterRecipeSerializer(IFactory<T> factory, int cookTime) {
        this.factory = factory;
        this.cookTime = cookTime;
    }

    public T read(ResourceLocation id, JsonObject json) {
        JsonArray ingredientJson = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a object");
        }
        JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        String fluidKey = JSONUtils.func_151200_h((JsonObject)resultJson, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidKey));
        if (fluid == null) {
            throw new JsonSyntaxException("Melter recipe result is null! Recipe is: " + id.toString());
        }
        FluidStack result = new FluidStack(fluid, JSONUtils.func_151203_m((JsonObject)resultJson, (String)"amount"));
        int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.cookTime);
        return this.factory.create(id, ingredient, result, cookTime);
    }

    public T read(ResourceLocation id, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.func_192575_l());
        if (fluid == null) {
            throw new JsonSyntaxException("Melter recipe result is null! Recipe is: " + id.toString());
        }
        int amount = buffer.func_150792_a();
        FluidStack result = new FluidStack(fluid, amount);
        int cookTime = buffer.func_150792_a();
        return this.factory.create(id, ingredient, result, cookTime);
    }

    public void write(PacketBuffer buffer, T recipe) {
        ((Ingredient)((MelterRecipe)recipe).func_192400_c().get(0)).func_199564_a(buffer);
        buffer.func_192572_a(((MelterRecipe)recipe).getResult().getFluid().getRegistryName());
        buffer.func_150787_b(((MelterRecipe)recipe).getResult().getAmount());
        buffer.func_150787_b(((MelterRecipe)recipe).getCookTime());
    }

    public static interface IFactory<T extends MelterRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, FluidStack var3, int var4);
    }
}

