/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.item.crafting;

import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModRecipes;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;

public class PizzaOvenRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final float experience;
    private final int cookTime;
    private final boolean isSimple;

    public PizzaOvenRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, float experience, int cookTime) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
        this.cookTime = cookTime;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.PIZZA_OVEN.get());
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.PIZZA_OVEN_SERIALIZER.get();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public float getExperience() {
        return this.experience;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public String func_193358_e() {
        return "";
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.PIZZA_OVEN;
    }
}

