/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.item.crafting;

import coffeecatrailway.coffeecheese.common.item.crafting.PizzaOvenRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PizzaOvenRecipeSerializer<T extends PizzaOvenRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;
    private final int cookTime;

    public PizzaOvenRecipeSerializer(IFactory<T> factory, int cookTime) {
        this.factory = factory;
        this.cookTime = cookTime;
    }

    public T read(ResourceLocation id, JsonObject json) {
        ItemStack stack;
        JsonArray ingredientJson = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement element : ingredientJson) {
            ingredients.add((Object)Ingredient.func_199802_a((JsonElement)element));
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            stack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resultId = new ResourceLocation(result);
            stack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resultId).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        }
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.cookTime);
        return this.factory.create(id, (NonNullList<Ingredient>)ingredients, stack, experience, cookTime);
    }

    public T read(ResourceLocation id, PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack stack = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int cookTime = buffer.func_150792_a();
        return this.factory.create(id, (NonNullList<Ingredient>)ingredients, stack, experience, cookTime);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_150787_b(((PizzaOvenRecipe)recipe).func_192400_c().size());
        for (int i = 0; i < ((PizzaOvenRecipe)recipe).func_192400_c().size(); ++i) {
            ((Ingredient)((PizzaOvenRecipe)recipe).func_192400_c().get(i)).func_199564_a(buffer);
        }
        buffer.func_150788_a(((PizzaOvenRecipe)recipe).func_77571_b());
        buffer.writeFloat(((PizzaOvenRecipe)recipe).getExperience());
        buffer.func_150787_b(((PizzaOvenRecipe)recipe).getCookTime());
    }

    public static interface IFactory<T extends PizzaOvenRecipe> {
        public T create(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3, float var4, int var5);
    }
}

