/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.tileentity;

import coffeecatrailway.coffeecheese.ModCheeseConfig;
import coffeecatrailway.coffeecheese.client.gui.container.GrillContainer;
import coffeecatrailway.coffeecheese.common.ModTags;
import coffeecatrailway.coffeecheese.common.block.GrillBlock;
import coffeecatrailway.coffeecheese.common.item.crafting.GrillRecipe;
import coffeecatrailway.coffeecheese.common.tileentity.LockableTileFluidHandler;
import coffeecatrailway.coffeecheese.registry.ModFluids;
import coffeecatrailway.coffeecheese.registry.ModRecipes;
import coffeecatrailway.coffeecheese.registry.ModTileEntities;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class GrillTileEntity
extends LockableTileFluidHandler
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    public static final int FLUID_CAPTACITY = 2000;
    public ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            GrillTileEntity.this.sendUpdates((TileEntity)GrillTileEntity.this);
        }
    };
    private final FluidTank catcherTank;
    private int burnTime;
    private int recipesUsed;
    private int cookTime;
    private int cookTimeTotal;
    public final IIntArray data = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return GrillTileEntity.this.burnTime;
                }
                case 1: {
                    return GrillTileEntity.this.recipesUsed;
                }
                case 2: {
                    return GrillTileEntity.this.cookTime;
                }
                case 3: {
                    return GrillTileEntity.this.cookTimeTotal;
                }
                case 4: {
                    return GrillTileEntity.this.tank.getFluidAmount();
                }
                case 5: {
                    return GrillTileEntity.this.catcherTank.getFluidAmount();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    GrillTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    GrillTileEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    GrillTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    GrillTileEntity.this.cookTimeTotal = value;
                    break;
                }
                case 4: {
                    GrillTileEntity.this.tank.setFluid(new FluidStack((Fluid)ModFluids.OIL_S.get(), value));
                    break;
                }
                case 5: {
                    GrillTileEntity.this.catcherTank.setFluid(new FluidStack((Fluid)ModFluids.OIL_S.get(), value));
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    };
    private final Map<ResourceLocation, Integer> recipeAmounts = Maps.newHashMap();
    private final IRecipeType<GrillRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public GrillTileEntity() {
        super((TileEntityType)ModTileEntities.GRILL.get(), 2000);
        this.tank.setValidator(fluid -> ModTags.Fluids.GRILL_OIL.func_199685_a_((Object)fluid.getFluid()));
        this.catcherTank = new FluidTank(1000);
        this.recipeType = ModRecipes.GRILLING;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.coffeecheese.grill", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new GrillContainer(id, player, (IInventory)this, this.data);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        if (compound.func_74764_b("catcherTank")) {
            this.catcherTank.readFromNBT((CompoundNBT)compound.func_74781_a("catcherTank"));
        }
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.recipesUsed = GrillTileEntity.getBurnTime(this.inventory.getStackInSlot(1));
        int i = compound.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + j));
            int k = compound.func_74762_e("RecipeAmount" + j);
            this.recipeAmounts.put(resourcelocation, k);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        if (((Boolean)this.func_195044_w().func_177229_b((IProperty)GrillBlock.HAS_CATCHER)).booleanValue()) {
            CompoundNBT tankNBT = new CompoundNBT();
            this.catcherTank.writeToNBT(tankNBT);
            compound.func_218657_a("catcherTank", (INBT)tankNBT);
        }
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74777_a("RecipesUsedSize", (short)this.recipeAmounts.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeAmounts.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
            this.sendUpdates((TileEntity)this);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = this.inventory.getStackInSlot(1);
            if (this.isBurning() || !fuelStack.func_190926_b() && !this.inventory.getStackInSlot(0).func_190926_b()) {
                IRecipe iRecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(iRecipe)) {
                    this.recipesUsed = this.burnTime = GrillTileEntity.getBurnTime(fuelStack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (fuelStack.hasContainerItem()) {
                            this.inventory.setStackInSlot(1, fuelStack.getContainerItem());
                        } else if (!fuelStack.func_190926_b()) {
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                this.inventory.setStackInSlot(1, fuelStack.getContainerItem());
                            }
                        }
                    }
                    this.sendUpdates((TileEntity)this);
                }
                if (this.isBurning() && this.canSmelt(iRecipe)) {
                    this.cookTime += ((Integer)ModCheeseConfig.grillSpeed.get()).intValue();
                    if (this.cookTime >= this.cookTimeTotal) {
                        this.tank.drain(this.getOilForRecipe(), IFluidHandler.FluidAction.EXECUTE);
                        if (((Boolean)this.func_195044_w().func_177229_b((IProperty)GrillBlock.HAS_CATCHER)).booleanValue()) {
                            int catchedOil = this.getOilForRecipe() / 2 + (this.field_145850_b.field_73012_v.nextInt(5) + 10);
                            if (this.catcherTank.getSpace() != 0) {
                                this.catcherTank.fill(new FluidStack((Fluid)ModFluids.OIL_S.get(), catchedOil), IFluidHandler.FluidAction.EXECUTE);
                            }
                            this.sendUpdates((TileEntity)this);
                        }
                        this.smeltRecipe(iRecipe);
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTimeTotal();
                        flag1 = true;
                        this.sendUpdates((TileEntity)this);
                    }
                } else {
                    this.cookTime = 0;
                    this.sendUpdates((TileEntity)this);
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
                this.sendUpdates((TileEntity)this);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)GrillBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
                this.sendUpdates((TileEntity)this);
            }
        }
        if (flag1) {
            this.sendUpdates((TileEntity)this);
        }
    }

    private boolean canSmelt(@Nullable IRecipe<?> iRecipe) {
        if (!this.inventory.getStackInSlot(0).func_190926_b() && iRecipe != null && this.tank.getFluidAmount() > 0 && this.tank.getFluidAmount() >= this.getOilForRecipe()) {
            ItemStack recipeOutStack = iRecipe.func_77571_b();
            if (recipeOutStack.func_190926_b()) {
                return false;
            }
            ItemStack outStack = this.inventory.getStackInSlot(2);
            if (outStack.func_190926_b()) {
                return true;
            }
            if (!outStack.func_77969_a(recipeOutStack)) {
                return false;
            }
            if (outStack.func_190916_E() + recipeOutStack.func_190916_E() <= this.func_70297_j_() && outStack.func_190916_E() + recipeOutStack.func_190916_E() <= outStack.func_77976_d()) {
                return true;
            }
            return outStack.func_190916_E() + recipeOutStack.func_190916_E() <= outStack.func_77976_d();
        }
        return false;
    }

    private void smeltRecipe(@Nullable IRecipe<?> iRecipe) {
        if (iRecipe != null && this.canSmelt(iRecipe)) {
            ItemStack ingredientStack = this.inventory.getStackInSlot(0);
            ItemStack recipeOutStack = iRecipe.func_77571_b();
            ItemStack outStack = this.inventory.getStackInSlot(2);
            if (outStack.func_190926_b()) {
                this.inventory.setStackInSlot(2, recipeOutStack.func_77946_l());
            } else if (outStack.func_77973_b() == recipeOutStack.func_77973_b()) {
                outStack.func_190917_f(recipeOutStack.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(iRecipe);
            }
            ingredientStack.func_190918_g(1);
        }
    }

    public static int getBurnTime(ItemStack fuelStack) {
        if (fuelStack.func_190926_b()) {
            return 0;
        }
        Item fuelItem = fuelStack.func_77973_b();
        int ret = fuelStack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)fuelStack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(fuelItem, 0) : ret));
    }

    private int getCookTimeTotal() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    private int getOilForRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(GrillRecipe::getOil).orElse(0);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return index >= 0 && index < this.func_70302_i_() && !this.inventory.getStackInSlot(index).func_190926_b() && count > 0 ? this.inventory.getStackInSlot(index).func_77979_a(count) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index >= 0 && index < this.func_70302_i_()) {
            ItemStack stack = this.inventory.getStackInSlot(index);
            this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = this.inventory.getStackInSlot(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.setStackInSlot(index, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.sendUpdates((TileEntity)this);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = this.inventory.getStackInSlot(1);
        return AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.recipeAmounts.compute(recipe.func_199560_c(), (location, integer) -> 1 + (integer == null ? 0 : integer));
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    @Override
    public void giveExperience(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeAmounts.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(iRecipe -> {
                list.add(iRecipe);
                this.giveExperience(player, (Integer)entry.getValue(), ((GrillRecipe)((Object)iRecipe)).func_222138_b());
            });
        }
        player.func_195065_a((Collection)list);
        this.recipeAmounts.clear();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            helper.func_194112_a(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public FluidTank getCatcherTank() {
        return this.catcherTank;
    }
}

