/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.tileentity;

import coffeecatrailway.coffeecheese.ModCheeseConfig;
import coffeecatrailway.coffeecheese.client.gui.container.MelterContainer;
import coffeecatrailway.coffeecheese.common.block.MelterBlock;
import coffeecatrailway.coffeecheese.common.item.crafting.MelterRecipe;
import coffeecatrailway.coffeecheese.common.item.crafting.PizzaOvenRecipe;
import coffeecatrailway.coffeecheese.common.tileentity.GrillTileEntity;
import coffeecatrailway.coffeecheese.common.tileentity.LockableTileFluidHandler;
import coffeecatrailway.coffeecheese.registry.ModRecipes;
import coffeecatrailway.coffeecheese.registry.ModTileEntities;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class MelterTileEntity
extends LockableTileFluidHandler
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    public static final int FLUID_CAPTACITY = 10000;
    public static final int DATA_ARRAY_SIZE = 7;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int recipesUsed;
    private int cookTime;
    private int cookTimeTotal;
    public final IIntArray data = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return MelterTileEntity.this.burnTime;
                }
                case 1: {
                    return MelterTileEntity.this.recipesUsed;
                }
                case 2: {
                    return MelterTileEntity.this.cookTime;
                }
                case 3: {
                    return MelterTileEntity.this.cookTimeTotal;
                }
                case 4: {
                    return MelterTileEntity.this.tank.getFluidAmount();
                }
                case 5: {
                    return Registry.field_212619_h.func_148757_b((Object)MelterTileEntity.this.tank.getFluid().getFluid());
                }
                case 6: {
                    return MelterTileEntity.this.tank.getFluid().getFluid().getAttributes().getColor((IEnviromentBlockReader)MelterTileEntity.this.field_145850_b, MelterTileEntity.this.func_174877_v());
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    MelterTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    MelterTileEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    MelterTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    MelterTileEntity.this.cookTimeTotal = value;
                    break;
                }
                case 4: {
                    MelterTileEntity.this.tank.setFluid(new FluidStack(MelterTileEntity.this.tank.getFluid().getFluid(), value));
                    break;
                }
                case 5: {
                    MelterTileEntity.this.tank.setFluid(new FluidStack((Fluid)Registry.field_212619_h.func_148745_a(value), 1));
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };
    private final Map<ResourceLocation, Integer> recipeAmounts = Maps.newHashMap();
    private final IRecipeType<MelterRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public MelterTileEntity() {
        super((TileEntityType)ModTileEntities.MELTER.get(), 10000);
        this.recipeType = ModRecipes.MELTING;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.coffeecheese.melter", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MelterContainer(id, player, (IInventory)this, this.data);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.recipesUsed = GrillTileEntity.getBurnTime((ItemStack)this.inventory.get(1));
        int i = compound.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + j));
            int k = compound.func_74762_e("RecipeAmount" + j);
            this.recipeAmounts.put(resourcelocation, k);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74777_a("RecipesUsedSize", (short)this.recipeAmounts.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeAmounts.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
            this.sendUpdates((TileEntity)this);
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(1);
            if (this.isBurning() || !fuelStack.func_190926_b() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                IRecipe iRecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(iRecipe)) {
                    this.recipesUsed = this.burnTime = GrillTileEntity.getBurnTime(fuelStack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (fuelStack.hasContainerItem()) {
                            this.inventory.set(1, (Object)fuelStack.getContainerItem());
                        } else if (!fuelStack.func_190926_b()) {
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                this.inventory.set(1, (Object)fuelStack.getContainerItem());
                            }
                        }
                    }
                    this.sendUpdates((TileEntity)this);
                }
                if (this.isBurning() && this.canSmelt(iRecipe)) {
                    this.cookTime += ((Integer)ModCheeseConfig.melterSpeed.get()).intValue();
                    if (this.cookTime >= this.cookTimeTotal) {
                        this.smeltRecipe(iRecipe);
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTimeTotal();
                        flag1 = true;
                        this.sendUpdates((TileEntity)this);
                    }
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
                this.sendUpdates((TileEntity)this);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)MelterBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
                this.sendUpdates((TileEntity)this);
            }
        }
        if (flag1) {
            this.sendUpdates((TileEntity)this);
        }
    }

    private boolean canSmelt(@Nullable IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof MelterRecipe)) {
            return false;
        }
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.tank.getFluidAmount() < this.tank.getCapacity() && this.tank.getCapacity() - this.tank.getFluidAmount() >= this.getRecipeResult().getAmount()) {
            MelterRecipe recipe = (MelterRecipe)iRecipe;
            FluidStack outStack = recipe.getResult();
            if (outStack.isEmpty()) {
                return false;
            }
            if (this.tank.isEmpty()) {
                return true;
            }
            if (!outStack.isFluidEqual(this.tank.getFluid())) {
                return false;
            }
            return outStack.getAmount() + this.tank.getFluidAmount() <= this.tank.getCapacity();
        }
        return false;
    }

    private void smeltRecipe(@Nullable IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof MelterRecipe)) {
            return;
        }
        if (this.canSmelt(iRecipe)) {
            MelterRecipe recipe = (MelterRecipe)iRecipe;
            ItemStack ingredientStack = (ItemStack)this.inventory.get(0);
            FluidStack recipeOutStack = recipe.getResult();
            FluidStack outStack = this.tank.getFluid();
            if (outStack.isEmpty()) {
                this.tank.setFluid(recipeOutStack.copy());
            } else if (outStack.getFluid() == recipeOutStack.getFluid()) {
                this.tank.fill(recipeOutStack, IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            ingredientStack.func_190918_g(1);
        }
    }

    private int getCookTimeTotal() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(MelterRecipe::getCookTime).orElse(200);
    }

    private FluidStack getRecipeResult() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(MelterRecipe::getResult).orElse(FluidStack.EMPTY);
    }

    public int[] func_180463_a(Direction side) {
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.sendUpdates((TileEntity)this);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.inventory.get(1);
        return AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack) || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.recipeAmounts.compute(recipe.func_199560_c(), (location, integer) -> 1 + (integer == null ? 0 : integer));
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    @Override
    public void giveExperience(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipeAmounts.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(iRecipe -> {
                list.add(iRecipe);
                this.giveExperience(player, (Integer)entry.getValue(), ((PizzaOvenRecipe)iRecipe).getExperience());
            });
        }
        player.func_195065_a((Collection)list);
        this.recipeAmounts.clear();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.func_194112_a(itemstack);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        super.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

