/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world;

import coffeecatrailway.coffeecheese.ModCheeseConfig;
import coffeecatrailway.coffeecheese.common.world.biome.BaseFoodBiome;
import coffeecatrailway.coffeecheese.common.world.feature.ModOreFeature;
import coffeecatrailway.coffeecheese.common.world.feature.ModOreFeatureConfig;
import coffeecatrailway.coffeecheese.registry.ModBiomes;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModEntities;
import coffeecatrailway.coffeecheese.registry.ModFeatures;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class ModWorldFeatures {
    private static final CountRangeConfig RANGE_FULL = new CountRangeConfig(20, 0, 0, 256);
    private static final Predicate<BlockState> TARGET_NETHER = s -> s.func_177230_c() == Blocks.field_150424_aL;
    private static final Predicate<BlockState> TARGET_END = s -> s.func_177230_c() == Blocks.field_150377_bs;
    private static final Predicate<BlockState> TARGET_OVERWORLD = s -> Tags.Blocks.STONE.func_199685_a_((Object)s.func_177230_c());

    public static void addFeatures() {
        ForgeRegistries.BIOMES.forEach(biome -> {
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                if (((Boolean)ModCheeseConfig.cheeseOreNetherGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.CHEESE_METAL_ORE_NETHER.get()).func_176223_P(), (Integer)ModCheeseConfig.cheeseOreNetherSize.get(), (Integer)ModCheeseConfig.cheeseOreNetherRegionSize.get(), TARGET_NETHER, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.grilledCheeseOreNetherGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.GRILLED_CHEESE_METAL_ORE_NETHER.get()).func_176223_P(), (Integer)ModCheeseConfig.grilledCheeseOreNetherSize.get(), (Integer)ModCheeseConfig.grilledCheeseOreNetherRegionSize.get(), TARGET_NETHER, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.hamRawOreNetherGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_RAW_METAL_ORE_NETHER.get()).func_176223_P(), (Integer)ModCheeseConfig.hamRawOreNetherSize.get(), (Integer)ModCheeseConfig.hamRawOreNetherRegionSize.get(), TARGET_NETHER, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.hamCookedOreNetherGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_COOKED_METAL_ORE_NETHER.get()).func_176223_P(), (Integer)ModCheeseConfig.hamCookedOreNetherSize.get(), (Integer)ModCheeseConfig.hamCookedOreNetherRegionSize.get(), TARGET_NETHER, RANGE_FULL);
                }
            } else if (biome.func_201856_r() == Biome.Category.THEEND) {
                if (((Boolean)ModCheeseConfig.cheeseOreEndGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.CHEESE_METAL_ORE_END.get()).func_176223_P(), (Integer)ModCheeseConfig.cheeseOreEndSize.get(), (Integer)ModCheeseConfig.cheeseOreEndRegionSize.get(), TARGET_END, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.grilledCheeseOreEndGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.GRILLED_CHEESE_METAL_ORE_END.get()).func_176223_P(), (Integer)ModCheeseConfig.grilledCheeseOreEndSize.get(), (Integer)ModCheeseConfig.grilledCheeseOreEndRegionSize.get(), TARGET_END, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.hamRawOreEndGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_RAW_METAL_ORE_END.get()).func_176223_P(), (Integer)ModCheeseConfig.hamRawOreEndSize.get(), (Integer)ModCheeseConfig.hamRawOreEndRegionSize.get(), TARGET_END, RANGE_FULL);
                }
                if (((Boolean)ModCheeseConfig.hamCookedOreEndGen.get()).booleanValue()) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_COOKED_METAL_ORE_END.get()).func_176223_P(), (Integer)ModCheeseConfig.hamCookedOreEndSize.get(), (Integer)ModCheeseConfig.hamCookedOreEndRegionSize.get(), TARGET_END, RANGE_FULL);
                }
            } else if (biome instanceof BaseFoodBiome) {
                boolean justHam;
                boolean isCheese = biome == ModBiomes.CHEESE_FOREST.get() || biome == ModBiomes.CHEESE_PLAINS.get();
                boolean isGrilledCheese = biome == ModBiomes.GRILLED_CHEESE_FOREST.get() || biome == ModBiomes.GRILLED_CHEESE_PLAINS.get();
                boolean justCheese = isCheese || isGrilledCheese;
                boolean isHamRaw = biome == ModBiomes.HAM_RAW_FOREST.get() || biome == ModBiomes.HAM_RAW_PLAINS.get();
                boolean isHamCooked = biome == ModBiomes.HAM_COOKED_FOREST.get() || biome == ModBiomes.HAM_COOKED_PLAINS.get();
                boolean bl = justHam = isHamRaw || isHamCooked;
                if (isCheese && (Integer)ModCheeseConfig.cheeseFoodieWeight.get() > 0) {
                    ((BaseFoodBiome)((Object)biome)).func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)ModEntities.CHEESE_FOODIE.get(), ((Integer)ModCheeseConfig.cheeseFoodieWeight.get()).intValue(), ((Integer)ModCheeseConfig.cheeseFoodieMin.get()).intValue(), ((Integer)ModCheeseConfig.cheeseFoodieMax.get()).intValue()));
                }
                if (isGrilledCheese && (Integer)ModCheeseConfig.grilledCheeseFoodieWeight.get() > 0) {
                    ((BaseFoodBiome)((Object)biome)).func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)ModEntities.GRILLED_CHEESE_FOODIE.get(), ((Integer)ModCheeseConfig.grilledCheeseFoodieWeight.get()).intValue(), ((Integer)ModCheeseConfig.grilledCheeseFoodieMin.get()).intValue(), ((Integer)ModCheeseConfig.grilledCheeseFoodieMax.get()).intValue()));
                }
                if (isHamRaw && (Integer)ModCheeseConfig.hamRawFoodieWeight.get() > 0) {
                    ((BaseFoodBiome)((Object)biome)).func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)ModEntities.HAM_RAW_FOODIE.get(), ((Integer)ModCheeseConfig.hamRawFoodieWeight.get()).intValue(), ((Integer)ModCheeseConfig.hamRawFoodieMin.get()).intValue(), ((Integer)ModCheeseConfig.hamRawFoodieMax.get()).intValue()));
                }
                if (isHamCooked && (Integer)ModCheeseConfig.hamCookedFoodieWeight.get() > 0) {
                    ((BaseFoodBiome)((Object)biome)).func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)ModEntities.HAM_COOKED_FOODIE.get(), ((Integer)ModCheeseConfig.hamCookedFoodieWeight.get()).intValue(), ((Integer)ModCheeseConfig.hamCookedFoodieMin.get()).intValue(), ((Integer)ModCheeseConfig.hamCookedFoodieMax.get()).intValue()));
                }
                if (justCheese) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.CHEESE_METAL_ORE.get()).func_176223_P(), (Integer)ModCheeseConfig.cheeseOreSize.get(), (Integer)ModCheeseConfig.cheeseOreRegionSize.get(), TARGET_OVERWORLD, new CountRangeConfig(20, 16, 20, 80));
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.GRILLED_CHEESE_METAL_ORE.get()).func_176223_P(), (Integer)ModCheeseConfig.grilledCheeseOreSize.get(), (Integer)ModCheeseConfig.grilledCheeseOreRegionSize.get(), TARGET_OVERWORLD, new CountRangeConfig(20, 16, 20, 80));
                }
                if (justHam) {
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_RAW_METAL_ORE.get()).func_176223_P(), (Integer)ModCheeseConfig.hamRawOreSize.get(), (Integer)ModCheeseConfig.hamRawOreRegionSize.get(), TARGET_OVERWORLD, new CountRangeConfig(20, 16, 20, 80));
                    ModWorldFeatures.addOre(biome, ((Block)ModBlocks.HAM_COOKED_METAL_ORE.get()).func_176223_P(), (Integer)ModCheeseConfig.hamCookedOreSize.get(), (Integer)ModCheeseConfig.hamCookedOreRegionSize.get(), TARGET_OVERWORLD, new CountRangeConfig(20, 16, 20, 80));
                    if (isHamRaw) {
                        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModFeatures.BACON_RAW_BALL.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215023_i, (IPlacementConfig)new ChanceConfig(3)));
                    }
                    if (isHamCooked) {
                        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModFeatures.BACON_COOKED_BALL.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215023_i, (IPlacementConfig)new ChanceConfig(3)));
                    }
                }
            }
        });
    }

    private static void addOre(Biome biome, BlockState state, int size, int regionSize, Predicate<BlockState> target, CountRangeConfig range) {
        ModWorldFeatures.addOre(biome, new ModOreFeatureConfig(state, size, regionSize, target), range);
    }

    private static void addOre(Biome biome, ModOreFeatureConfig config, CountRangeConfig rangeConfig) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)ModOreFeature.INSTANCE, (IFeatureConfig)config, (Placement)Placement.field_215028_n, (IPlacementConfig)rangeConfig));
    }
}

