/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world.biome.layer;

import coffeecatrailway.coffeecheese.common.world.biome.layer.ModBiomeLayer;
import coffeecatrailway.coffeecheese.common.world.biome.layer.ModLayer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.MixRiverLayer;
import net.minecraft.world.gen.layer.RiverLayer;
import net.minecraft.world.gen.layer.ShoreLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.eventbus.api.Event;

public class ModLayerUtil {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> areaFactory, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = areaFactory;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> buildProcedure(WorldType type, OverworldGenSettings settings, LongFunction<C> contextFactory) {
        int i;
        IAreaFactory<T> areaFactory = ModLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        areaFactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), (IAreaFactory)areaFactory);
        areaFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), (IAreaFactory)areaFactory);
        areaFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), (IAreaFactory)areaFactory);
        areaFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)areaFactory);
        areaFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(50L), (IAreaFactory)areaFactory);
        areaFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(70L), (IAreaFactory)areaFactory);
        areaFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), (IAreaFactory)areaFactory);
        areaFactory = EdgeLayer.CoolWarm.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)areaFactory);
        areaFactory = EdgeLayer.HeatIce.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)areaFactory);
        areaFactory = EdgeLayer.Special.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), (IAreaFactory)areaFactory);
        areaFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2002L), (IAreaFactory)areaFactory);
        areaFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), (IAreaFactory)areaFactory);
        areaFactory = ModLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, areaFactory, 0, contextFactory);
        int j = i = 4;
        if (type == WorldType.field_77135_d) {
            i = 6;
        }
        i = ModLayerUtil.getModdedBiomeSize(type, i);
        IAreaFactory lvt_7_1_ = ModLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, areaFactory, 0, contextFactory);
        lvt_7_1_ = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_7_1_);
        IAreaFactory lvt_8_1_ = ModLayerUtil.getBiomeLayer(type, areaFactory, settings, contextFactory);
        IAreaFactory<T> lvt_9_1_ = ModLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_8_1_ = HillsLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_, lvt_9_1_);
        lvt_7_1_ = ModLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_7_1_ = ModLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, j, contextFactory);
        lvt_7_1_ = RiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), lvt_7_1_);
        lvt_7_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_7_1_);
        for (int k = 0; k < i; ++k) {
            lvt_8_1_ = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + k), lvt_8_1_);
            if (k == 0) {
                lvt_8_1_ = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), lvt_8_1_);
            }
            if (k != 1 && i != 1) continue;
            lvt_8_1_ = ShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        }
        lvt_8_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        lvt_8_1_ = MixRiverLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_8_1_, lvt_7_1_);
        IAreaFactory iareafactory5 = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), lvt_8_1_);
        return ImmutableList.of((Object)lvt_8_1_, (Object)iareafactory5, (Object)lvt_8_1_);
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> getBiomeLayer(WorldType worldType, IAreaFactory<T> parentLayer, OverworldGenSettings settings, LongFunction<C> contextFactory) {
        parentLayer = new ModBiomeLayer(worldType, settings).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), parentLayer);
        parentLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)parentLayer, (int)2, contextFactory);
        parentLayer = EdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), parentLayer);
        return parentLayer;
    }

    public static Layer[] buildProcedure(long seed, WorldType typeIn, OverworldGenSettings settings) {
        int i = 25;
        ImmutableList immutablelist = ModLayerUtil.buildProcedure(typeIn, settings, (long seedModifier) -> new LazyAreaLayerContext(25, seed, seedModifier));
        Layer layer = new Layer((IAreaFactory)immutablelist.get(0));
        Layer layer1 = new Layer((IAreaFactory)immutablelist.get(1));
        Layer layer2 = new Layer((IAreaFactory)immutablelist.get(2));
        return new Layer[]{layer, layer1, layer2};
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewSize();
    }
}

