/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world.dimension;

import coffeecatrailway.coffeecheese.common.world.dimension.FoodWorldBiomeProvider;
import coffeecatrailway.coffeecheese.common.world.dimension.FoodWorldChunkGenerator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FoodWorldDimension
extends Dimension {
    public FoodWorldDimension(World world, DimensionType type) {
        super(world, type);
    }

    public ChunkGenerator<?> func_186060_c() {
        FoodWorldBiomeProvider biomeProvider = new FoodWorldBiomeProvider(this.field_76579_a, new OverworldGenSettings());
        return new FoodWorldChunkGenerator(this.field_76579_a, biomeProvider, FoodWorldChunkGenerator.Config.createDefault());
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPos, boolean checkValid) {
        for (int i = chunkPos.func_180334_c(); i <= chunkPos.func_180332_e(); ++i) {
            for (int j = chunkPos.func_180333_d(); j <= chunkPos.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, posX & 0xF, posZ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, posX & 0xF, posZ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(posX, j, posZ);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals((Object)blockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 192.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }
}

