/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world.dimension;

import coffeecatrailway.coffeecheese.common.block.FoodWorldPortalBlock;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class FoodWorldTeleporter
extends Teleporter {
    private final Object2LongMap<ColumnPos> field_222275_f = new Object2LongOpenHashMap();
    protected final Map<ColumnPos, PortalPosition> field_85191_c = Maps.newHashMapWithExpectedSize((int)4096);

    public FoodWorldTeleporter(ServerWorld world) {
        super(world);
    }

    public boolean func_222268_a(Entity entity, float rotationYaw) {
        ColumnPos columnpos = new ColumnPos(entity.func_180425_c());
        double distance = -1.0;
        boolean doesPortalExist = true;
        BlockPos location = BlockPos.field_177992_a;
        if (this.field_85191_c.containsKey(columnpos)) {
            PortalPosition portalPosition = this.field_85191_c.get(columnpos);
            distance = 0.0;
            location = portalPosition.pos;
            portalPosition.lastUpdateTime = this.field_85192_a.func_82737_E();
            doesPortalExist = false;
        } else {
            BlockPos entityPos = new BlockPos(entity);
            for (int offsetX = -128; offsetX <= 128; ++offsetX) {
                for (int offsetZ = -128; offsetZ <= 128; ++offsetZ) {
                    BlockPos currentPos = entityPos.func_177982_a(offsetX, this.field_85192_a.func_72940_L() - 1 - entityPos.func_177956_o(), offsetZ);
                    while (currentPos.func_177956_o() >= 0) {
                        BlockPos positionCache = currentPos.func_177977_b();
                        if (this.field_85192_a.func_180495_p(currentPos).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                            while (this.field_85192_a.func_180495_p(positionCache = currentPos.func_177977_b()).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                                currentPos = positionCache;
                            }
                            double distanceToEntity = currentPos.func_177951_i((Vec3i)entityPos);
                            if (distance < 0.0 || distanceToEntity < distance) {
                                distance = distanceToEntity;
                                location = currentPos;
                            }
                        }
                        currentPos = positionCache;
                    }
                }
            }
        }
        if (distance >= 0.0) {
            if (doesPortalExist) {
                this.field_85191_c.put(columnpos, new PortalPosition(location, this.field_85192_a.func_201672_e().func_82737_E()));
            }
            double tpX = (double)location.func_177958_n() + 0.5;
            double tpY = (double)location.func_177956_o() + 0.5;
            double tpZ = (double)location.func_177952_p() + 0.5;
            Direction direction = null;
            if (this.field_85192_a.func_180495_p(location.func_177976_e()).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                direction = Direction.NORTH;
            }
            if (this.field_85192_a.func_180495_p(location.func_177974_f()).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                direction = Direction.SOUTH;
            }
            if (this.field_85192_a.func_180495_p(location.func_177978_c()).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                direction = Direction.EAST;
            }
            if (this.field_85192_a.func_180495_p(location.func_177968_d()).func_177230_c() == ModBlocks.FOOD_PORTAL.get()) {
                direction = Direction.WEST;
            }
            Direction enumfacing1 = Direction.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3));
            if (direction != null) {
                Direction enumfacing2 = direction.func_176735_f();
                BlockPos blockpos2 = location.func_177972_a(direction);
                boolean flag2 = this.isInsideBlock(blockpos2);
                boolean flag3 = this.isInsideBlock(blockpos2.func_177972_a(enumfacing2));
                if (flag3 && flag2) {
                    location = location.func_177972_a(enumfacing2);
                    direction = direction.func_176734_d();
                    enumfacing2 = enumfacing2.func_176734_d();
                    BlockPos blockpos3 = location.func_177972_a(direction);
                    flag2 = this.isInsideBlock(blockpos3);
                    flag3 = this.isInsideBlock(blockpos3.func_177972_a(enumfacing2));
                }
                float f6 = 0.5f;
                float f1 = 0.5f;
                if (!flag3 && flag2) {
                    f6 = 1.0f;
                } else if (flag3 && !flag2) {
                    f6 = 0.0f;
                } else if (flag3) {
                    f1 = 0.0f;
                }
                tpX = (double)location.func_177958_n() + 0.5;
                tpY = (double)location.func_177956_o() + 0.5;
                tpZ = (double)location.func_177952_p() + 0.5;
                tpX += (double)((float)enumfacing2.func_82601_c() * f6 + (float)direction.func_82601_c() * f1);
                tpZ += (double)((float)enumfacing2.func_96559_d() * f6 + (float)direction.func_96559_d() * f1);
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                if (direction == enumfacing1) {
                    f2 = 1.0f;
                    f3 = 1.0f;
                } else if (direction == enumfacing1.func_176734_d()) {
                    f2 = -1.0f;
                    f3 = -1.0f;
                } else if (direction == enumfacing1.func_176746_e()) {
                    f4 = 1.0f;
                    f5 = -1.0f;
                } else {
                    f4 = -1.0f;
                    f5 = 1.0f;
                }
                double d2 = entity.func_213322_ci().func_82615_a();
                double d3 = entity.func_213322_ci().func_82616_c();
                entity.func_213293_j(d2 * (double)f2 + d3 * (double)f5, 0.0, d2 * (double)f4 + d3 * (double)f3);
                entity.field_70177_z = rotationYaw - (float)(enumfacing1.func_176736_b() * 90) + (float)(direction.func_176736_b() * 90);
            } else {
                entity.func_213293_j(0.0, 0.0, 0.0);
            }
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(tpX, tpY, tpZ, entity.field_70177_z, entity.field_70125_A);
                ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
            } else {
                entity.func_70012_b(tpX, tpY, tpZ, entity.field_70177_z, entity.field_70125_A);
            }
            return true;
        }
        return false;
    }

    private boolean isInsideBlock(BlockPos position) {
        return !this.field_85192_a.func_175623_d(position) || !this.field_85192_a.func_175623_d(position.func_177984_a());
    }

    public boolean func_85188_a(Entity entity) {
        return FoodWorldTeleporter.createPortal((World)this.field_85192_a, new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)), entity);
    }

    public static boolean createPortal(World world, BlockPos pos, @Nullable Entity entity) {
        BlockState portalState = ((FoodWorldPortalBlock)ModBlocks.FOOD_PORTAL.get()).func_176223_P();
        BlockState snowstate = ((Block)ModBlocks.CHEESE_BLOCK.get()).func_176223_P();
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        while (!world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150349_c) {
            pos = pos.func_177984_a();
        }
        for (BlockPos basePos : BlockPos.MutableBlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(basePos, snowstate, 2);
        }
        for (BlockPos airPos : BlockPos.MutableBlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, 2, -1), (BlockPos)pos.func_177982_a(2, 3, 1))) {
            world.func_180501_a(airPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos portalPos : BlockPos.MutableBlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            world.func_180501_a(portalPos, portalState, 2);
        }
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            this.func_222270_b(worldTime);
            this.func_222269_c(worldTime);
        }
    }

    private void func_222270_b(long worldTime) {
        LongIterator longiterator = this.field_222275_f.values().iterator();
        while (longiterator.hasNext()) {
            long i = longiterator.nextLong();
            if (i > worldTime) continue;
            longiterator.remove();
        }
    }

    private void func_222269_c(long worldTime) {
        long i = worldTime - 300L;
        Iterator<Map.Entry<ColumnPos, PortalPosition>> iterator = this.field_85191_c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ColumnPos, PortalPosition> entry = iterator.next();
            PortalPosition teleporter$portalposition = entry.getValue();
            if (teleporter$portalposition.lastUpdateTime >= i) continue;
            ColumnPos columnpos = entry.getKey();
            Supplier[] suppliers = new Supplier[2];
            Dimension dimension = this.field_85192_a.func_201675_m();
            suppliers[0] = () -> ((Dimension)dimension).func_186058_p();
            suppliers[1] = () -> columnpos;
            this.field_85192_a.func_72863_F().func_217222_b(TicketType.field_219493_f, new ChunkPos(teleporter$portalposition.pos), 3, (Object)columnpos);
            iterator.remove();
        }
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long lastUpdateTime) {
            this.pos = pos;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

