/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world.feature;

import coffeecatrailway.coffeecheese.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BaconBallFeature
extends Feature<NoFeatureConfig> {
    private final BlockState block;

    public BaconBallFeature(boolean cooked, Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
        this.block = cooked ? ((Block)ModBlocks.BACON_COOKED_BLOCK.get()).func_176223_P() : ((Block)ModBlocks.BACON_RAW_BLOCK.get()).func_176223_P();
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (rand.nextFloat() < 0.5f) {
            BlockState state = world.func_180495_p(pos);
            while (state.func_196958_f() && pos.func_177956_o() > 0) {
                pos = pos.func_177977_b();
                state = world.func_180495_p(pos);
            }
            int offset = rand.nextInt(2);
            int ret = 0;
            for (int height = 0; height < 128; ++height) {
                for (int i = 0; i < 2; ++i) {
                    int x = rand.nextInt(2);
                    int y = rand.nextInt(2);
                    int z = rand.nextInt(2);
                    float dist = (float)(height + y + z) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-x, -y + offset - height, -z), (BlockPos)pos.func_177982_a(x, y + offset - height, z))) {
                        if (!(blockpos.func_177951_i((Vec3i)pos) <= (double)(dist * dist)) || !this.block.func_196955_c((IWorldReader)world, pos)) continue;
                        world.func_180501_a(blockpos, this.block, 2);
                        ++ret;
                    }
                    pos = pos.func_177982_a(-rand.nextInt(2), -rand.nextInt(2), -rand.nextInt(2));
                }
            }
            return ret > 0;
        }
        return false;
    }
}

