/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.common.world.feature.tree;

import coffeecatrailway.coffeecheese.common.world.feature.tree.TreeFeature;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CheeseTreeFeature
extends TreeFeature<NoFeatureConfig> {
    private final int minTreeHeight;
    private final BlockState trunk;
    private final BlockState leaf;

    public CheeseTreeFeature(boolean grilled, Function<Dynamic<?>, ? extends NoFeatureConfig> dynamicFunction, boolean doBlockNofityOnPlace) {
        super(dynamicFunction, doBlockNofityOnPlace);
        if (grilled) {
            this.minTreeHeight = 6;
            this.trunk = ((Block)ModBlocks.GRILLED_CHEESE_LOG.get()).func_176223_P();
            this.leaf = ((Block)ModBlocks.GRILLED_CHEESE_LEAVES.get()).func_176223_P();
        } else {
            this.minTreeHeight = 4;
            this.trunk = ((Block)ModBlocks.CHEESE_LOG.get()).func_176223_P();
            this.leaf = ((Block)ModBlocks.CHEESE_LEAVES.get()).func_176223_P();
        }
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random rand, BlockPos position, MutableBoundingBox mutableBoundingBox) {
        int i = this.minTreeHeight + rand.nextInt(3);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= world.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.getMaxHeight()) {
                            if (CheeseTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (this.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b()) && position.func_177956_o() < world.getMaxHeight() - i - 1) {
                this.setDirtAt(world, position.func_177977_b(), position);
                for (int l2 = position.func_177956_o() - 3 + i; l2 <= position.func_177956_o() + i; ++l2) {
                    int l3 = l2 - (position.func_177956_o() + i);
                    int j4 = (int)(1.0f - (float)l3 / 1.05f);
                    for (int j1 = position.func_177958_n() - j4; j1 <= position.func_177958_n() + j4; ++j1) {
                        int k1 = j1 - position.func_177958_n();
                        for (int l1 = position.func_177952_p() - j4; l1 <= position.func_177952_p() + j4; ++l1) {
                            BlockPos blockpos;
                            int i2 = l1 - position.func_177952_p();
                            if (Math.abs(k1) == j4 && (Math.abs(i2) == j4 || l3 == 0) || !CheeseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(blockpos = new BlockPos(j1, l2, l1))) && !this.isSoil((IWorldGenerationBaseReader)world, blockpos)) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, blockpos, this.leaf, mutableBoundingBox);
                        }
                    }
                }
                for (int i3 = 0; i3 < i; ++i3) {
                    if (!CheeseTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)position.func_177981_b(i3)) && !this.isSoil((IWorldGenerationBaseReader)world, position.func_177981_b(i3))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, position.func_177981_b(i3), this.trunk, mutableBoundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

