/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.compat.jei;

import coffeecatrailway.coffeecheese.client.gui.screen.GrillScreen;
import coffeecatrailway.coffeecheese.common.item.crafting.GrillRecipe;
import coffeecatrailway.coffeecheese.compat.jei.JEIModPlugin;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModFluids;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GrillRecipeCategory
implements IRecipeCategory<GrillRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated oil;
    private final IDrawable oilMetor;
    private final String localizedName;

    public GrillRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GrillScreen.GUI_TEXTURE, 33, 6, 107, 68);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.GRILL.get()));
        this.flame = guiHelper.drawableBuilder(GrillScreen.GUI_TEXTURE, 176, 0, 14, 14).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.drawableBuilder(GrillScreen.GUI_TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.oil = guiHelper.drawableBuilder(GrillScreen.GUI_TEXTURE, 176, 97, 16, 64).buildAnimated(100, IDrawableAnimated.StartDirection.TOP, true);
        this.oilMetor = guiHelper.createDrawable(GrillScreen.GUI_TEXTURE, 176, 32, 16, 64);
        this.localizedName = ((Block)ModBlocks.GRILL.get()).func_200291_n().getString();
    }

    public ResourceLocation getUid() {
        return JEIModPlugin.GRILL;
    }

    public Class<? extends GrillRecipe> getRecipeClass() {
        return GrillRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(GrillRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
        inputs.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModFluids.OIL_BUCKET.get()}));
        ingredients.setInputIngredients(inputs);
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)ModFluids.OIL_S.get(), recipe.getOil()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout layout, GrillRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 27, 6);
        guiItemStacks.init(2, false, 85, 26);
        guiItemStacks.set(ingredients);
    }

    public void draw(GrillRecipe recipe, double mouseX, double mouseY) {
        this.flame.draw(28, 28);
        this.arrow.draw(51, 27);
        float experience = recipe.func_222138_b();
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
        this.oil.draw(2, 2);
        this.oilMetor.draw(2, 2);
    }

    public List<String> getTooltipStrings(GrillRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (mouseX >= 2.0 && mouseY >= 2.0 && mouseX <= 17.0 && mouseY <= 65.0) {
            tooltips.add(GrillScreen.getFormatedOilString(recipe.getOil()));
        }
        return tooltips;
    }
}

