/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.compat.jei;

import coffeecatrailway.coffeecheese.CheeseMod;
import coffeecatrailway.coffeecheese.client.gui.screen.GrillScreen;
import coffeecatrailway.coffeecheese.client.gui.screen.MelterScreen;
import coffeecatrailway.coffeecheese.client.gui.screen.PizzaOvenScreen;
import coffeecatrailway.coffeecheese.compat.jei.GrillRecipeCategory;
import coffeecatrailway.coffeecheese.compat.jei.MelterRecipeCategory;
import coffeecatrailway.coffeecheese.compat.jei.PizzaOvenRecipeCategory;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import coffeecatrailway.coffeecheese.registry.ModRecipes;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIModPlugin
implements IModPlugin {
    private static final ResourceLocation UID = CheeseMod.getLocation("plugin/main");
    static final ResourceLocation GRILL = CheeseMod.getLocation("category/grill");
    static final ResourceLocation MELTER = CheeseMod.getLocation("category/melter");
    static final ResourceLocation PIZZA_OVEN = CheeseMod.getLocation("category/pizza_oven");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GrillRecipeCategory(guiHelper), new MelterRecipeCategory(guiHelper), new PizzaOvenRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(JEIModPlugin.getRecipesOfType(ModRecipes.GRILLING), GRILL);
        reg.addRecipes(JEIModPlugin.getRecipesOfType(ModRecipes.MELTING), MELTER);
        reg.addRecipes(JEIModPlugin.getRecipesOfType(ModRecipes.PIZZA_OVEN), PIZZA_OVEN);
    }

    private static List<IRecipe<?>> getRecipesOfType(IRecipeType<?> type) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(rec -> rec.func_222127_g() == type).collect(Collectors.toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.GRILL.get()), new ResourceLocation[]{GRILL});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.MELTER.get()), new ResourceLocation[]{MELTER});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PIZZA_OVEN.get()), new ResourceLocation[]{PIZZA_OVEN});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(GrillScreen.class, 85, 33, 24, 17, new ResourceLocation[]{GRILL});
        reg.addRecipeClickArea(MelterScreen.class, 68, 33, 24, 17, new ResourceLocation[]{MELTER});
        reg.addRecipeClickArea(PizzaOvenScreen.class, 101, 33, 24, 17, new ResourceLocation[]{PIZZA_OVEN});
    }
}

