/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.compat.jei;

import coffeecatrailway.coffeecheese.client.gui.screen.MelterScreen;
import coffeecatrailway.coffeecheese.common.item.crafting.MelterRecipe;
import coffeecatrailway.coffeecheese.compat.jei.JEIModPlugin;
import coffeecatrailway.coffeecheese.registry.ModBlocks;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MelterRecipeCategory
implements IRecipeCategory<MelterRecipe> {
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;
    private final IDrawable fluidMetor;
    private final String localizedName;

    public MelterRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(MelterScreen.GUI_TEXTURE, 42, 6, 89, 68);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.MELTER.get()));
        this.flame = guiHelper.drawableBuilder(MelterScreen.GUI_TEXTURE, 176, 0, 14, 14).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.drawableBuilder(MelterScreen.GUI_TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidMetor = guiHelper.createDrawable(MelterScreen.GUI_TEXTURE, 176, 32, 32, 64);
        this.localizedName = ((Block)ModBlocks.MELTER.get()).func_200291_n().getString();
    }

    public ResourceLocation getUid() {
        return JEIModPlugin.MELTER;
    }

    public Class<? extends MelterRecipe> getRecipeClass() {
        return MelterRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MelterRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.getResult().getFluid().func_204524_b()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout layout, MelterRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 1, 6);
        guiItemStacks.set(ingredients);
    }

    public void draw(MelterRecipe recipe, double mouseX, double mouseY) {
        this.flame.draw(2, 28);
        this.arrow.draw(25, 27);
        FluidStack fluidStack = recipe.getResult();
        ResourceLocation fluidTexture = MelterScreen.getFluidTexture(fluidStack.getFluid());
        if (fluidTexture != null) {
            if (fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a)) {
                GlStateManager.color4f((float)0.23922f, (float)0.42745f, (float)1.0f, (float)1.0f);
            }
            int k = (int)MelterScreen.mapFluid(fluidStack.getAmount(), 0.0f, 64.0f) + 2;
            int h = MelterScreen.getFluidTextureHeight(fluidTexture);
            IDrawableStatic fluidDraw = this.guiHelper.drawableBuilder(fluidTexture, 0, 0, 32, k).setTextureSize(16, h - k).build();
            fluidDraw.draw(55, 2 + this.fluidMetor.getHeight() - k);
            if (fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a)) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        this.fluidMetor.draw(55, 2);
    }

    public List<String> getTooltipStrings(MelterRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (mouseX >= 55.0 && mouseY >= 2.0 && mouseX <= 86.0 && mouseY <= 65.0) {
            tooltips.add(MelterScreen.getFormatedFluidString(recipe.getResult().getFluid(), recipe.getResult().getAmount()));
        }
        return tooltips;
    }
}

