/*
 * Decompiled with CFR 0.152.
 */
package coffeecatrailway.coffeecheese.registry;

import coffeecatrailway.coffeecheese.common.block.FoodGrassBlock;
import coffeecatrailway.coffeecheese.common.entity.CheeseBallEntity;
import coffeecatrailway.coffeecheese.common.entity.CheeseFoodie;
import coffeecatrailway.coffeecheese.common.entity.GrilledCheeseFoodie;
import coffeecatrailway.coffeecheese.common.entity.HamCookedFoodie;
import coffeecatrailway.coffeecheese.common.entity.HamRawFoodie;
import coffeecatrailway.coffeecheese.common.entity.item.BoatEntityCM;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "coffeecheese");
    public static final RegistryObject<EntityType<CheeseBallEntity>> CHEESE_BALL = ENTITIES.register("cheese_ball", () -> EntityType.Builder.func_220322_a(CheeseBallEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setCustomClientFactory((packet, world) -> new CheeseBallEntity((World)world)).func_206830_a("cheese_ball"));
    public static final RegistryObject<EntityType<CheeseFoodie>> CHEESE_FOODIE = ENTITIES.register("cheese_foodie", () -> EntityType.Builder.func_220322_a(CheeseFoodie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 1.15f).setCustomClientFactory((packet, world) -> new CheeseFoodie((World)world)).func_206830_a("cheese_foodie"));
    public static final RegistryObject<EntityType<GrilledCheeseFoodie>> GRILLED_CHEESE_FOODIE = ENTITIES.register("grilled_cheese_foodie", () -> EntityType.Builder.func_220322_a(GrilledCheeseFoodie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 1.15f).setCustomClientFactory((packet, world) -> new GrilledCheeseFoodie((World)world)).func_206830_a("grilled_cheese_foodie"));
    public static final RegistryObject<EntityType<HamRawFoodie>> HAM_RAW_FOODIE = ENTITIES.register("ham_raw_foodie", () -> EntityType.Builder.func_220322_a(HamRawFoodie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 1.15f).setCustomClientFactory((packet, world) -> new HamRawFoodie((World)world)).func_206830_a("ham_raw_foodie"));
    public static final RegistryObject<EntityType<HamCookedFoodie>> HAM_COOKED_FOODIE = ENTITIES.register("ham_cooked_foodie", () -> EntityType.Builder.func_220322_a(HamCookedFoodie::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 1.15f).setCustomClientFactory((packet, world) -> new HamCookedFoodie((World)world)).func_206830_a("ham_cooked_foodie"));
    public static final RegistryObject<EntityType<? extends BoatEntity>> BOAT = ENTITIES.register("food_boat", () -> EntityType.Builder.func_220322_a(BoatEntityCM::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(1.375f, 0.5625f).setCustomClientFactory(BoatEntityCM::new).func_206830_a("food_boat"));

    public static void registerSpawnPlacements(RegistryEvent.Register<EntityType<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ENTITIES.getRegistryName())) {
            return;
        }
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CHEESE_FOODIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ModEntities::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GRILLED_CHEESE_FOODIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ModEntities::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HAM_RAW_FOODIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ModEntities::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HAM_COOKED_FOODIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ModEntities::canSpawn);
    }

    public static boolean canSpawn(EntityType<? extends AnimalEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return ModEntities.canSpawn(world.func_180495_p(pos.func_177977_b())) && world.func_201669_a(pos, 0) > 8;
    }

    public static boolean canSpawn(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof GrassBlock || block instanceof GrassPathBlock || block == Blocks.field_150346_d || block instanceof FoodGrassBlock;
    }
}

