/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.data;

import com.colt.ccam.registries.ccamRecipe;
import com.colt.ccam.sewingstation.AbstractSingleItemRecipe;
import com.colt.ccam.util.RecipeHelper;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SingleItemRecipeBuilder {
    private String group;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private final AbstractSingleItemRecipe.Serializer<?> recipeSerializer;

    private SingleItemRecipeBuilder(Ingredient ingredient, ItemStack result, AbstractSingleItemRecipe.Serializer<?> serializer) {
        this.ingredient = ingredient;
        this.result = result;
        this.recipeSerializer = serializer;
    }

    public static SingleItemRecipeBuilder recipe(Ingredient ingredient, ItemStack result, AbstractSingleItemRecipe.Serializer<?> serializer) {
        return new SingleItemRecipeBuilder(ingredient, result, serializer);
    }

    public static SingleItemRecipeBuilder sewingRecipe(Ingredient ingredient, ItemStack result) {
        return SingleItemRecipeBuilder.recipe(ingredient, result, (AbstractSingleItemRecipe.Serializer)ccamRecipe.SEWING.get());
    }

    public static SingleItemRecipeBuilder sewingRecipe(Ingredient ingredient, IItemProvider result, int count) {
        return SingleItemRecipeBuilder.recipe(ingredient, new ItemStack(result, count), (AbstractSingleItemRecipe.Serializer)ccamRecipe.SEWING.get());
    }

    public static SingleItemRecipeBuilder sewingRecipe(Ingredient ingredient, IItemProvider result) {
        return SingleItemRecipeBuilder.recipe(ingredient, new ItemStack(result), (AbstractSingleItemRecipe.Serializer)ccamRecipe.SEWING.get());
    }

    public SingleItemRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return this;
    }

    public SingleItemRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, this.result.func_77973_b().getRegistryName());
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation1 = new ResourceLocation(save);
        ResourceLocation resourcelocation = this.result.func_77973_b().getRegistryName();
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.build(consumerIn, resourcelocation1);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.ingredient, this.result, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77973_b().func_77640_w().func_200300_c() + "/" + id.func_110623_a()), this.recipeSerializer));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<? extends AbstractSingleItemRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, Advancement.Builder advancementBuilder, ResourceLocation advancementId, IRecipeSerializer<? extends AbstractSingleItemRecipe> serializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
            this.serializer = serializer;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.func_200304_c());
            json.add("result", RecipeHelper.serializeItemStack(this.result));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

