/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.sewingstation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractSingleItemRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final IRecipeType<?> type;
    private final IRecipeSerializer<?> serializer;

    public AbstractSingleItemRecipe(IRecipeType<?> type, IRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, int time, ItemStack result) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public String func_193358_e() {
        return this.group;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public NonNullList<ItemStack> func_179532_b(IInventory inv) {
        return NonNullList.func_191196_a();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public static class Serializer<T extends AbstractSingleItemRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return this.factory.create(recipeId, group, ingredient, time, stack);
        }

        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_218666_n();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int time = buffer.readInt();
            ItemStack stack = buffer.func_150791_c();
            return this.factory.create(recipeId, group, ingredient, time, stack);
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((AbstractSingleItemRecipe)recipe).group);
            ((AbstractSingleItemRecipe)recipe).ingredient.func_199564_a(buffer);
            buffer.func_150788_a(((AbstractSingleItemRecipe)recipe).result);
        }

        public static interface IRecipeFactory<T extends AbstractSingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, int var4, ItemStack var5);
        }
    }
}

