/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.sewingstation;

import com.colt.ccam.sewingstation.SewingRecipe;
import com.colt.ccam.sewingstation.SewingStationContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class SewingStationScreen
extends ContainerScreen<SewingStationContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;

    public SewingStationScreen(SewingStationContainer handler, PlayerInventory inventory, ITextComponent title) {
        super((Container)handler, inventory, title);
        handler.setInventoryUpdateListener(this::onInventoryChange);
        --this.field_238743_q_;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.func_230459_a_(matrices, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrices, float delta, int mouseX, int mouseY) {
        this.func_230446_a_(matrices);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrices, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.scrollAmount);
        this.func_238474_b_(matrices, i + 119, j + 15 + k, 176 + (this.shouldScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int m = this.field_147009_r + 14;
        int n = this.scrollOffset + 12;
        this.renderRecipeBackground(matrices, mouseX, mouseY, l, m, n);
        this.renderRecipeIcons(l, m, n);
    }

    protected void func_230451_b_(MatrixStack matrices, int x, int y) {
        super.func_230451_b_(matrices, x, y);
        if (this.canCraft) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.scrollOffset + 12;
            List<SewingRecipe> list = ((SewingStationContainer)this.field_147002_h).getRecipeList();
            for (int l = this.scrollOffset; l < k && l < ((SewingStationContainer)this.field_147002_h).getRecipeListSize(); ++l) {
                int m = l - this.scrollOffset;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                this.func_230457_a_(matrices, list.get(l).func_77571_b(), x, y);
            }
        }
    }

    private void renderRecipeBackground(MatrixStack matrixStack, int i, int j, int k, int l, int m) {
        for (int n = this.scrollOffset; n < m && n < ((SewingStationContainer)this.field_147002_h).getRecipeListSize(); ++n) {
            int o = n - this.scrollOffset;
            int p = k + o % 4 * 16;
            int q = o / 4;
            int r = l + q * 18 + 2;
            int s = this.field_147000_g;
            if (n == ((SewingStationContainer)this.field_147002_h).getSelectedRecipe()) {
                s += 18;
            } else if (i >= p && j >= r && i < p + 16 && j < r + 18) {
                s += 36;
            }
            this.func_238474_b_(matrixStack, p, r - 1, 0, s, 16, 18);
        }
    }

    private void renderRecipeIcons(int x, int y, int scrollOffset) {
        List<SewingRecipe> list = ((SewingStationContainer)this.field_147002_h).getRecipeList();
        for (int i = this.scrollOffset; i < scrollOffset && i < ((SewingStationContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            this.field_230706_i_.func_175599_af().func_180450_b(list.get(i).func_77571_b(), k, m);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int m = l - this.scrollOffset;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0) || !(e >= 0.0) || !(d < 16.0) || !(e < 18.0) || !((SewingStationContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((SewingStationContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = MathHelper.func_76131_a((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - amount / (double)i);
            this.scrollAmount = MathHelper.func_76131_a((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((SewingStationContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    protected int getMaxScroll() {
        return (((SewingStationContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((SewingStationContainer)this.field_147002_h).hasItemsinInputSlot();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

