/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.util.rotation;

public class Coordinate {
    private double x;
    private double y;

    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    public Coordinate set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Coordinate translate(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Coordinate scale(double scale) {
        return this.scale(scale, scale);
    }

    public Coordinate scale(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Coordinate rotate(double angle, double center, boolean isDegrees) {
        if (isDegrees) {
            angle = Math.toRadians(angle);
        }
        double x0 = this.x;
        double y0 = this.y;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        this.x = (x0 - center) * cos - (y0 - center) * sin + center;
        this.y = (y0 - center) * cos + (x0 - center) * sin + center;
        return this;
    }
}

