/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.util.rotation;

import com.colt.ccam.util.rotation.Coordinate;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

public class Coordinate3d {
    private double x;
    private double y;
    private double z;

    public Coordinate3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d getCoordinate() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Coordinate3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Coordinate3d translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Coordinate3d scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Coordinate3d scale(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Coordinate3d rotate(Direction.Axis axis, double angle, double center, boolean isDegrees) {
        return this.setRotation(axis, this.getAxis(axis).rotate(angle, center, isDegrees).getCoordinate());
    }

    private Coordinate getAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new Coordinate(this.y, this.z);
            }
            case Y: {
                return new Coordinate(this.x, this.z);
            }
            case Z: {
                return new Coordinate(this.x, this.y);
            }
        }
        throw new IndexOutOfBoundsException("No three-dimensional axis named " + axis.func_176719_a());
    }

    private Coordinate3d setRotation(Direction.Axis axis, double[] coordinate) {
        switch (axis) {
            case X: {
                this.y = coordinate[0];
                this.z = coordinate[1];
                break;
            }
            case Y: {
                this.x = coordinate[0];
                this.z = coordinate[1];
                break;
            }
            case Z: {
                this.x = coordinate[0];
                this.y = coordinate[1];
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No three-dimensional axis named " + axis.func_176719_a());
            }
        }
        return this;
    }
}

