/*
 * Decompiled with CFR 0.152.
 */
package com.colt.ccam.util.rotation;

import com.colt.ccam.util.rotation.Coordinate3d;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class RotationHelper {
    public static VoxelShape rotateDegrees(Direction.Axis axis, double angle, VoxelShape shape) {
        return RotationHelper.rotateDegrees(axis, angle, 0.5, shape);
    }

    public static VoxelShape rotateDegrees(Direction.Axis axis, double angle, double center, VoxelShape shape) {
        return RotationHelper.rotate(axis, angle, center, true, shape);
    }

    public static VoxelShape rotateRadians(Direction.Axis axis, double angle, VoxelShape shape) {
        return RotationHelper.rotateRadians(axis, angle, 0.5, shape);
    }

    public static VoxelShape rotateRadians(Direction.Axis axis, double angle, double center, VoxelShape shape) {
        return RotationHelper.rotate(axis, angle, center, false, shape);
    }

    public static VoxelShape rotate(Direction.Axis axis, double angle, double center, boolean isDegrees, VoxelShape shape) {
        return shape.func_197756_d().stream().map(box -> RotationHelper.rotate(axis, angle, center, isDegrees, box)).reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
    }

    private static VoxelShape rotate(Direction.Axis axis, double angle, double center, boolean isDegrees, AxisAlignedBB box) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(new Coordinate3d(box.field_72340_a, box.field_72338_b, box.field_72339_c).rotate(axis, angle, center, isDegrees).getCoordinate(), new Coordinate3d(box.field_72336_d, box.field_72337_e, box.field_72334_f).rotate(axis, angle, center, isDegrees).getCoordinate()));
    }

    public static Map<Direction, VoxelShape> createYRotationMap(VoxelShape original) {
        return (Map)Util.func_200696_a(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, original);
            map.put(Direction.EAST, RotationHelper.rotateDegrees(Direction.Axis.Y, 90.0, original));
            map.put(Direction.SOUTH, RotationHelper.rotateDegrees(Direction.Axis.Y, 180.0, original));
            map.put(Direction.WEST, RotationHelper.rotateDegrees(Direction.Axis.Y, 270.0, original));
        });
    }
}

