/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOreBlockItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class CompactOre {
    private CompactOreBlock block;
    private Item blockItem;
    private ResourceLocation baseBlockLoc;
    private int minRolls;
    private int maxRolls;
    private ResourceLocation baseOreTexture;
    private ResourceLocation baseUnderlyingTexture;
    private float spawnProbability;
    private boolean useGetDrops;
    private int maxOreLayerColorDiff;
    private boolean lateGeneration;
    private ResourceLocation registryName;

    public CompactOre(ResourceLocation baseBlockLoc, int minRolls, int maxRolls, ResourceLocation baseOreTexture, ResourceLocation baseUnderlyingTexture, float spawnProbability, boolean useGetDrops, int maxOreLayerColorDiff, boolean lateGeneration) {
        this.baseBlockLoc = baseBlockLoc;
        this.minRolls = minRolls;
        this.maxRolls = maxRolls;
        this.baseOreTexture = new ResourceLocation(baseOreTexture.func_110624_b(), "textures/" + baseOreTexture.func_110623_a() + ".png");
        this.baseUnderlyingTexture = new ResourceLocation(baseUnderlyingTexture.func_110624_b(), "textures/" + baseUnderlyingTexture.func_110623_a() + ".png");
        this.spawnProbability = spawnProbability;
        this.useGetDrops = useGetDrops;
        this.maxOreLayerColorDiff = maxOreLayerColorDiff;
        this.lateGeneration = lateGeneration;
        this.registryName = new ResourceLocation("compactores", "compact_" + baseBlockLoc.func_110624_b() + "_" + baseBlockLoc.func_110623_a());
    }

    public void init1_block() {
        this.block = new CompactOreBlock(this.registryName, this.baseBlockLoc, this.useGetDrops, this.minRolls, this.maxRolls);
    }

    public void init2_item() {
        this.blockItem = new CompactOreBlockItem(this.block);
    }

    public CompactOreBlock getBlock() {
        return this.block;
    }

    public Item getBlockItem() {
        return this.blockItem;
    }

    public Block getBaseBlock() {
        return this.block.baseBlock();
    }

    public int getMinRolls() {
        return this.minRolls;
    }

    public int getMaxRolls() {
        return this.maxRolls;
    }

    public ResourceLocation getBaseOreTexture() {
        return this.baseOreTexture;
    }

    public ResourceLocation getBaseUnderlyingTexture() {
        return this.baseUnderlyingTexture;
    }

    public float getSpawnProbability() {
        return this.spawnProbability;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getMaxOreLayerColorDiff() {
        return this.maxOreLayerColorDiff;
    }

    public boolean isLateGeneration() {
        return this.lateGeneration;
    }
}

