/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class CompactOreBlock
extends Block {
    private ResourceLocation baseBlockLoc;
    private Block baseBlock = null;
    private boolean useGetDrops;
    private int minRolls;
    private int maxRolls;

    public CompactOreBlock(ResourceLocation registryName, ResourceLocation baseBlockLoc, boolean useGetDrops, int minRolls, int maxRolls) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d));
        this.baseBlockLoc = baseBlockLoc;
        this.useGetDrops = useGetDrops;
        this.minRolls = minRolls;
        this.maxRolls = maxRolls;
        this.setRegistryName(registryName);
    }

    Block baseBlock() {
        return this.baseBlock != null ? this.baseBlock : (Block)ForgeRegistries.BLOCKS.getValue(this.baseBlockLoc);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.baseBlock().getExplosionResistance(state, world, pos, exploder, explosion);
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        Random rand = Optional.of(world.func_217349_x(pos).getWorldForge()).map(IWorld::func_201674_k).orElse(new Random());
        int r = this.minRolls + rand.nextInt(this.maxRolls - this.minRolls + 1);
        return this.baseBlock().getExpDrop(state, world, pos, fortune, silktouch) * r;
    }

    public int getHarvestLevel(BlockState state) {
        return this.baseBlock().getHarvestLevel(state);
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.baseBlock().getHarvestTool(state);
    }

    public float func_176195_g(BlockState state, IBlockReader p_176195_2_, BlockPos pos) {
        return this.baseBlock().func_176195_g(state, p_176195_2_, pos);
    }

    public float func_149638_a() {
        return this.baseBlock().func_149638_a();
    }

    public Material func_149688_o(BlockState state) {
        return this.baseBlock().func_149688_o(state);
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader p_180659_2_, BlockPos pos) {
        return this.baseBlock().func_180659_g(state, p_180659_2_, pos);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.baseBlock().canHarvestBlock(state, world, pos, player);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return this.baseBlock().isToolEffective(state, tool);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.baseBlock().getSoundType(state, world, pos, entity);
    }

    public SoundType func_220072_p(BlockState state) {
        return this.baseBlock().func_220072_p(state);
    }

    public ResourceLocation func_220068_i() {
        return this.getRegistryName();
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        if (this.useGetDrops) {
            List drops = this.baseBlock().func_220076_a(p_220076_1_, p_220076_2_);
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            int r = this.minRolls + p_220076_2_.func_216018_a().func_201674_k().nextInt(this.maxRolls - this.minRolls + 1);
            for (int i = 0; i < r; ++i) {
                for (ItemStack stack : drops) {
                    ret.add(stack.func_77946_l());
                }
            }
            return ret;
        }
        return super.func_220076_a(p_220076_1_, p_220076_2_);
    }

    public String func_149739_a() {
        return this.func_200291_n().func_150254_d();
    }

    public ITextComponent func_200291_n() {
        return new TranslationTextComponent("block.compactores.compact_ore", new Object[]{this.baseBlock().func_200291_n()});
    }
}

