/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class CompactOreTexture {
    private static boolean redrawOreBase = false;
    private static Map<ResourceLocation, TextureInfo> generatedTextureCache = new HashMap<ResourceLocation, TextureInfo>();
    private static Map<ResourceLocation, TextureInfo> baseTextureCache = new HashMap<ResourceLocation, TextureInfo>();

    public static TextureInfo generate(ResourceLocation baseBlock, ResourceLocation baseTexture, ResourceLocation oreBlock, ResourceLocation oreTexture, int maxOreLayerDiff) {
        if (generatedTextureCache.containsKey(oreBlock)) {
            return generatedTextureCache.get(oreBlock);
        }
        try {
            int oreFactor;
            int commonHeight;
            int baseCommonHeightFactor;
            TextureInfo base;
            if (baseTextureCache.containsKey(baseTexture)) {
                base = baseTextureCache.get(baseTexture);
            } else {
                base = TextureInfo.generate(baseBlock, baseTexture);
                baseTextureCache.put(baseTexture, base);
            }
            TextureInfo ore = TextureInfo.generate(oreBlock, oreTexture);
            if (base.isInterpolate()) {
                base = CompactOreTexture.interpolateManually(base);
            }
            if (ore.isInterpolate()) {
                ore = CompactOreTexture.interpolateManually(ore);
            }
            int baseWidth = base.getWidth();
            int baseHeight = base.getHeight();
            int oreWidth = ore.getWidth();
            int oreHeight = ore.getHeight();
            int commonWidth = CompactOreTexture.lcm(baseWidth, oreWidth);
            int baseCommonWidthFactor = commonWidth / baseWidth;
            int baseFactor = CompactOreTexture.lcm(baseCommonWidthFactor, baseCommonHeightFactor = (commonHeight = CompactOreTexture.lcm(baseHeight, oreHeight)) / baseHeight);
            if (baseFactor * baseHeight != (oreFactor = baseFactor * baseWidth / oreWidth) * oreHeight) {
                throw new RuntimeException("Aspect ratio mismatch (oreFactor=" + oreFactor + ", baseFactor=" + baseFactor + ", baseDimensions=" + baseWidth + "x" + baseHeight + ", oreDimensions=" + oreWidth + "x" + oreHeight + ")");
            }
            base = CompactOreTexture.scale(base, baseFactor);
            ore = CompactOreTexture.scale(ore, oreFactor);
            int animBase = base.getTotalAnimationTime();
            int animOre = ore.getTotalAnimationTime();
            if (animBase != 0 && animOre != 0) {
                int animCommon = CompactOreTexture.lcm(animBase, animOre);
                base = CompactOreTexture.repeatAnimation(base, animCommon / animBase);
                ore = CompactOreTexture.repeatAnimation(ore, animCommon / animOre);
            }
            TextureInfo result = CompactOreTexture.generateCompactTexture(base, ore, maxOreLayerDiff);
            generatedTextureCache.put(oreBlock, result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate compact ore texture (baseBlock=" + baseBlock + ", oreBlock=" + oreBlock + ", baseTexture=" + baseTexture + ", oreTexture=" + oreTexture + ")", e);
        }
    }

    private static TextureInfo interpolateManually(TextureInfo texture) {
        ArrayList<BufferedImage> newImages = new ArrayList<BufferedImage>();
        int currentMasterIndex = 0;
        int currentMasterTime = texture.getFrametimes().get(0);
        int currentMasterPreviousTime = 0;
        int targetFrames = texture.getTotalAnimationTime();
        for (int currentFrame = 0; currentFrame < targetFrames; ++currentFrame) {
            if (currentMasterTime + currentMasterPreviousTime == currentFrame) {
                currentMasterPreviousTime += currentMasterTime;
                currentMasterTime = texture.getFrametimes().get(++currentMasterIndex);
            }
            BufferedImage beforeTexture = texture.getTextures().get(currentMasterIndex);
            BufferedImage afterTexture = texture.getTextures().get(currentMasterIndex + 1 < texture.getTextures().size() ? currentMasterIndex + 1 : 0);
            double factor = (double)(currentFrame - currentMasterPreviousTime) / (double)currentMasterTime;
            newImages.add(CompactOreTexture.makeInterpolatedImage(factor, beforeTexture, afterTexture));
        }
        Object[] newFrametimesArray = new Integer[newImages.size()];
        Arrays.fill(newFrametimesArray, (Object)1);
        List<Object> newFrametimes = Arrays.asList(newFrametimesArray);
        return new TextureInfo(texture.getTextureOwner(), newImages, newFrametimes, false);
    }

    private static BufferedImage makeInterpolatedImage(double factor, BufferedImage from, BufferedImage to) {
        int w = from.getWidth();
        int h = from.getHeight();
        WritableRaster fromRaster = from.getRaster();
        WritableRaster toRaster = to.getRaster();
        int[] dataBufferFrom = new int[fromRaster.getNumBands()];
        int[] dataBufferTo = new int[toRaster.getNumBands()];
        BufferedImage result = new BufferedImage(w, h, from.getType());
        WritableRaster resultRaster = result.getRaster();
        int[] dataBufferResult = new int[resultRaster.getNumBands()];
        if (dataBufferResult.length != dataBufferFrom.length || dataBufferFrom.length != dataBufferTo.length) {
            throw new RuntimeException("When interpolating: Buffer array size mismatch");
        }
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                fromRaster.getPixel(x, y, dataBufferFrom);
                toRaster.getPixel(x, y, dataBufferTo);
                for (int i = 0; i < dataBufferResult.length; ++i) {
                    dataBufferResult[i] = CompactOreTexture.interpolateColor(factor, dataBufferTo[i], dataBufferFrom[i]);
                }
                resultRaster.setPixel(x, y, dataBufferResult);
            }
        }
        return result;
    }

    private static int interpolateColor(double factor, int to, int from) {
        return (int)(factor * (double)to + (1.0 - factor) * (double)from);
    }

    private static TextureInfo scale(TextureInfo texture, int factor) {
        if (factor == 1) {
            return texture;
        }
        ArrayList<BufferedImage> scaledImages = new ArrayList<BufferedImage>(texture.getTextures().size());
        for (BufferedImage image : texture.getTextures()) {
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage newImage = new BufferedImage(w * factor, h * factor, image.getType());
            WritableRaster oldRaster = image.getRaster();
            WritableRaster newRaster = newImage.getRaster();
            int[] pixelData = new int[oldRaster.getNumBands()];
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    oldRaster.getPixel(x, y, pixelData);
                    for (int fx = 0; fx < factor; ++fx) {
                        for (int fy = 0; fy < factor; ++fy) {
                            newRaster.setPixel(x * factor + fx, y * factor + fy, pixelData);
                        }
                    }
                }
            }
            scaledImages.add(newImage);
        }
        return new TextureInfo(texture.getTextureOwner(), scaledImages, texture.getFrametimes(), texture.isInterpolate());
    }

    private static TextureInfo repeatAnimation(TextureInfo texture, int numRepeats) {
        if (numRepeats == 1) {
            return texture;
        }
        List<BufferedImage> oldTextures = texture.getTextures();
        List<Integer> oldFrametimes = texture.getFrametimes();
        ArrayList<BufferedImage> newTextures = new ArrayList<BufferedImage>();
        ArrayList<Integer> newFrametimes = new ArrayList<Integer>();
        for (int i = 0; i < numRepeats; ++i) {
            newTextures.addAll(oldTextures);
            newFrametimes.addAll(oldFrametimes);
        }
        return new TextureInfo(texture.getTextureOwner(), newTextures, newFrametimes, texture.isInterpolate());
    }

    private static TextureInfo generateCompactTexture(TextureInfo base, TextureInfo ore, int maxOreLayerDiff) {
        int animBase = base.getTotalAnimationTime();
        int animOre = ore.getTotalAnimationTime();
        ResourceLocation finalTextureOwner = new ResourceLocation("compactores", "compact_" + ore.getTextureOwner().func_110624_b() + "_" + ore.getTextureOwner().func_110623_a());
        if (animBase == 0 && animOre == 0) {
            return new TextureInfo(finalTextureOwner, Collections.singletonList(CompactOreTexture.actuallyFinallyMakeTheTexture(base.getTextures().get(0), ore.getTextures().get(0), maxOreLayerDiff)), Collections.singletonList(0), false);
        }
        int numFrames = Math.max(animBase, animOre);
        int baseFrame = 0;
        int oreFrame = 0;
        int baseFramePrev = -1;
        int oreFramePrev = -1;
        int baseFrametime = animBase == 0 ? Integer.MAX_VALUE : base.getFrametimes().get(0);
        int oreFrametime = animOre == 0 ? Integer.MAX_VALUE : ore.getFrametimes().get(0);
        int frametimeCounter = 0;
        ArrayList<BufferedImage> finalTextures = new ArrayList<BufferedImage>(numFrames);
        ArrayList<Integer> finalFrametimes = new ArrayList<Integer>();
        for (int i = 0; i < numFrames; ++i) {
            if (baseFrame != baseFramePrev || oreFrame != oreFramePrev) {
                finalTextures.add(CompactOreTexture.actuallyFinallyMakeTheTexture(base.getTextures().get(baseFrame), ore.getTextures().get(oreFrame), maxOreLayerDiff));
                baseFramePrev = baseFrame;
                oreFramePrev = oreFrame;
            }
            ++frametimeCounter;
            if (--baseFrametime == 0 && i + 1 < numFrames) {
                baseFrametime = base.getFrametimes().get(++baseFrame);
                if (frametimeCounter > 0) {
                    finalFrametimes.add(frametimeCounter);
                    frametimeCounter = 0;
                }
            }
            if (--oreFrametime != 0 || i + 1 >= numFrames) continue;
            oreFrametime = ore.getFrametimes().get(++oreFrame);
            if (frametimeCounter <= 0) continue;
            finalFrametimes.add(frametimeCounter);
            frametimeCounter = 0;
        }
        finalFrametimes.add(frametimeCounter);
        return new TextureInfo(finalTextureOwner, finalTextures, finalFrametimes, false);
    }

    private static BufferedImage actuallyFinallyMakeTheTexture(BufferedImage base, BufferedImage ore, int maxOreLayerDiff) {
        int w = base.getWidth();
        int h = base.getHeight();
        BufferedImage oreLayer = maxOreLayerDiff < 0 ? CompactOreTexture.findOreLayerExactMatch(base, ore, w, h) : CompactOreTexture.findOreLayerAttempt3(base, ore, w, h, maxOreLayerDiff);
        BufferedImage result = new BufferedImage(w, h, 1);
        Graphics2D g = result.createGraphics();
        int xOff = Math.max(1, w / 16);
        int yOff = Math.max(1, h / 16);
        g.drawImage((Image)base, 0, 0, null);
        g.drawImage((Image)(redrawOreBase ? ore : oreLayer), 0, 0, null);
        g.drawImage((Image)oreLayer, xOff, yOff, null);
        g.drawImage((Image)oreLayer, -xOff, -yOff, null);
        g.drawImage((Image)oreLayer, xOff, 0, null);
        return result;
    }

    private static BufferedImage findOreLayerExactMatch(BufferedImage base, BufferedImage ore, int w, int h) {
        BufferedImage oreLayer = new BufferedImage(w, h, 2);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (ore.getRGB(x, y) == base.getRGB(x, y)) continue;
                oreLayer.setRGB(x, y, ore.getRGB(x, y));
            }
        }
        return oreLayer;
    }

    private static BufferedImage findOreLayerAttempt3(BufferedImage base, BufferedImage ore, int w, int h, int maxDiff) {
        int y;
        int x;
        BufferedImage oreLayer = new BufferedImage(w, h, 2);
        HashSet<Integer> baseLayerColors = new HashSet<Integer>();
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                baseLayerColors.add(base.getRGB(x, y));
            }
        }
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                int a = ore.getRGB(x, y);
                boolean isRock = false;
                Iterator iterator = baseLayerColors.iterator();
                while (iterator.hasNext()) {
                    int c = (Integer)iterator.next();
                    int diff = Math.abs(CompactOreTexture.r(a) - CompactOreTexture.r(c)) + Math.abs(CompactOreTexture.g(a) - CompactOreTexture.g(c)) + Math.abs(CompactOreTexture.b(a) - CompactOreTexture.b(c));
                    if (diff > maxDiff) continue;
                    isRock = true;
                    break;
                }
                if (isRock) continue;
                oreLayer.setRGB(x, y, a);
            }
        }
        return oreLayer;
    }

    private static int r(int rgb) {
        return rgb / 65536 & 0xFF;
    }

    private static int g(int rgb) {
        return rgb / 256 & 0xFF;
    }

    private static int b(int rgb) {
        return rgb & 0xFF;
    }

    private static int gcd(int a, int b) {
        if (a == b) {
            return a;
        }
        if (a > b) {
            return CompactOreTexture.gcd(a - b, b);
        }
        return CompactOreTexture.gcd(a, b - a);
    }

    private static int lcm(int a, int b) {
        return a * b / CompactOreTexture.gcd(a, b);
    }

    public static void registerCacheInvalidator() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            if (resourcePredicate.test(VanillaResourceType.TEXTURES)) {
                baseTextureCache.clear();
                generatedTextureCache.clear();
            }
        }));
    }

    public static void setRedrawOreBase(boolean redrawOreBase) {
        CompactOreTexture.redrawOreBase = redrawOreBase;
    }

    public static class TextureInfo {
        private ResourceLocation textureOwner;
        private List<BufferedImage> textures;
        private List<Integer> frametimes;
        private boolean interpolate;

        public TextureInfo(ResourceLocation textureOwner, List<BufferedImage> textures, List<Integer> frametimes, boolean interpolate) {
            this.textureOwner = textureOwner;
            this.textures = textures;
            this.frametimes = frametimes;
            this.interpolate = interpolate;
        }

        public ResourceLocation getTextureOwner() {
            return this.textureOwner;
        }

        public List<BufferedImage> getTextures() {
            return this.textures;
        }

        public List<Integer> getFrametimes() {
            return this.frametimes;
        }

        public boolean isInterpolate() {
            return this.interpolate;
        }

        public int getTotalAnimationTime() {
            return this.frametimes.stream().mapToInt(t -> t).sum();
        }

        public int getWidth() {
            return this.textures.get(0).getWidth();
        }

        public int getHeight() {
            return this.textures.get(0).getHeight();
        }

        public BufferedImage generateImage() {
            int imgHeight = this.getHeight();
            BufferedImage img = new BufferedImage(this.getWidth(), imgHeight * this.textures.size(), 2);
            Graphics2D g = img.createGraphics();
            for (int i = 0; i < this.textures.size(); ++i) {
                g.drawImage((Image)this.textures.get(i), 0, i * imgHeight, null);
            }
            return img;
        }

        public JsonObject generateMeta() {
            JsonObject meta = new JsonObject();
            JsonObject animation = new JsonObject();
            animation.addProperty("interpolate", Boolean.valueOf(this.interpolate));
            animation.addProperty("width", (Number)this.getWidth());
            animation.addProperty("height", (Number)this.getHeight());
            JsonArray frames = new JsonArray();
            for (int i = 0; i < this.frametimes.size(); ++i) {
                JsonObject frame = new JsonObject();
                frame.addProperty("index", (Number)i);
                frame.addProperty("time", (Number)this.frametimes.get(i));
                frames.add((JsonElement)frame);
            }
            animation.add("frames", (JsonElement)frames);
            meta.add("animation", (JsonElement)animation);
            return meta;
        }

        public static TextureInfo generate(ResourceLocation textureOwner, ResourceLocation texture) throws IOException {
            ResourceLocation metaLocation = new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + ".mcmeta");
            IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
            IResource texRes = rm.func_199002_a(texture);
            BufferedImage tex = ImageIO.read(texRes.func_199027_b());
            ArrayList<BufferedImage> textures = new ArrayList<BufferedImage>(1);
            textures.add(tex);
            ArrayList<Integer> frametimes = new ArrayList<Integer>(1);
            frametimes.add(0);
            boolean interpolate = false;
            Number width = 1;
            Number height = 1;
            int frametime = 1;
            try {
                JsonObject meta = new JsonParser().parse((Reader)new InputStreamReader(rm.func_199002_a(metaLocation).func_199027_b())).getAsJsonObject();
                if (!meta.has("animation") || !(meta.get("animation") instanceof JsonObject)) {
                    throw new ClassCastException();
                }
                JsonObject animation = meta.getAsJsonObject("animation");
                if (animation.has("interpolate") && animation.get("interpolate").isJsonPrimitive() && animation.get("interpolate").getAsJsonPrimitive().isBoolean()) {
                    interpolate = animation.get("interpolate").getAsBoolean();
                }
                if (animation.has("width") && animation.get("width").isJsonPrimitive() && animation.get("width").getAsJsonPrimitive().isNumber() && animation.has("height") && animation.get("height").isJsonPrimitive() && animation.get("height").getAsJsonPrimitive().isNumber()) {
                    width = animation.get("width").getAsNumber();
                    height = animation.get("height").getAsNumber();
                }
                if (animation.has("frametime") && animation.get("frametime").isJsonPrimitive() && animation.get("frametime").getAsJsonPrimitive().isNumber()) {
                    frametime = animation.get("frametime").getAsInt();
                }
                if (animation.has("frames") && animation.get("frames").isJsonArray()) {
                    JsonArray frames = animation.getAsJsonArray("frames");
                    BufferedImage originalImage = textures.remove(0);
                    frametimes.remove(0);
                    int frameWidth = originalImage.getWidth();
                    int frameHeight = (int)Math.round((double)frameWidth * ((Number)height).doubleValue() / width.doubleValue());
                    for (JsonElement entry : frames) {
                        int index = 0;
                        int time = frametime;
                        if (entry.isJsonPrimitive() && entry.getAsJsonPrimitive().isNumber()) {
                            index = entry.getAsInt();
                        } else if (entry.isJsonObject()) {
                            JsonObject frameInfo = entry.getAsJsonObject();
                            if (frameInfo.has("index") && frameInfo.get("index").isJsonPrimitive() && frameInfo.getAsJsonPrimitive("index").isNumber()) {
                                index = frameInfo.get("index").getAsInt();
                            }
                            if (frameInfo.has("time") && frameInfo.get("time").isJsonPrimitive() && frameInfo.getAsJsonPrimitive("time").isNumber()) {
                                time = frameInfo.get("time").getAsInt();
                            }
                        }
                        frametimes.add(time);
                        int y = index * frameHeight;
                        textures.add(originalImage.getSubimage(0, y, frameWidth, frameHeight));
                    }
                }
                return new TextureInfo(textureOwner, textures, frametimes, interpolate);
            }
            catch (IOException | ClassCastException e) {
                return new TextureInfo(textureOwner, textures, frametimes, interpolate);
            }
        }
    }
}

