/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import doublenegation.mods.compactores.CompactOre;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.SimplePlacement;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class CompactOreWorldGen {
    @ObjectHolder(value="compactores:all_with_probability")
    private static Placement<ProbabilityConfig> ALL_WITH_PROBABILITY_PLACEMENT = null;

    public static void init(Map<ResourceLocation, CompactOre> ores) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            for (CompactOre ore : ores.values()) {
                biome.func_203611_a(ore.isLateGeneration() ? GenerationStage.Decoration.UNDERGROUND_DECORATION : GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202294_an, (IFeatureConfig)new ReplaceBlockConfig(ore.getBaseBlock().func_176223_P(), ore.getBlock().func_176223_P()), ALL_WITH_PROBABILITY_PLACEMENT, (IPlacementConfig)new ProbabilityConfig(ore.getSpawnProbability())));
            }
        }
    }

    public static class AllWithProbability
    extends SimplePlacement<ProbabilityConfig> {
        public AllWithProbability(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i51362_1_) {
            super(p_i51362_1_);
        }

        protected Stream<BlockPos> getPositions(Random random, ProbabilityConfig probabilityConfig, BlockPos blockPos) {
            Stream.Builder<BlockPos> builder = Stream.builder();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        if (!(random.nextFloat() <= probabilityConfig.probability)) continue;
                        builder.add(blockPos.func_177982_a(x, y, z));
                    }
                }
            }
            return builder.build();
        }
    }

    public static class ProbabilityConfig
    implements IPlacementConfig {
        public final float probability;

        public ProbabilityConfig(float probability) {
            this.probability = probability;
        }

        public <T> Dynamic<T> func_214719_a(DynamicOps<T> dynamicOps) {
            return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("probability"), (Object)dynamicOps.createFloat(this.probability))));
        }

        public static ProbabilityConfig deserialize(Dynamic<?> dynamic) {
            return new ProbabilityConfig(dynamic.get("probability").asFloat(0.1f));
        }
    }
}

