/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOreWorldGen;
import doublenegation.mods.compactores.CompactOresConfig;
import doublenegation.mods.compactores.CompactOresResourcePack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compactores")
public class CompactOres {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, CompactOre> compactOres = new HashMap<ResourceLocation, CompactOre>();
    private static CompactOresResourcePack resourcePack;
    private static ItemGroup itemGroup;

    public CompactOres() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (CompactOre ore : CompactOresConfig.loadConfigs()) {
            LOGGER.info("Loaded compact ore " + ore.getRegistryName() + " from configuration!");
            compactOres.put(ore.getRegistryName(), ore);
        }
        resourcePack = new CompactOresResourcePack(this::getOreList);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            LOGGER.info("Attaching CompactOre resources to the Minecraft client");
            Minecraft.func_71410_x().func_195548_H().func_198982_a((IPackFinder)resourcePack);
            CompactOreTexture.registerCacheInvalidator();
        });
    }

    private Map<ResourceLocation, CompactOre> getOreList() {
        return compactOres;
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        CompactOreWorldGen.init(compactOres);
    }

    public static CompactOre getFor(ResourceLocation loc) {
        return compactOres.get(loc);
    }

    public static ItemGroup getItemGroup() {
        return itemGroup;
    }

    @SubscribeEvent
    public void startServer(FMLServerAboutToStartEvent event) {
        LOGGER.info("Attaching CompactOre resources to the Minecraft server");
        event.getServer().func_195561_aH().func_198982_a((IPackFinder)resourcePack);
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent breakEvent) {
        for (CompactOre ore : compactOres.values()) {
            if (!((Object)((Object)ore.getBlock())).equals(breakEvent.getState().func_177230_c())) continue;
            int numEvents = ore.getMinRolls() + breakEvent.getWorld().func_201674_k().nextInt(ore.getMaxRolls() - ore.getMinRolls() + 1);
            for (int i = 0; i < numEvents; ++i) {
                MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((World)breakEvent.getWorld(), breakEvent.getPos(), ore.getBaseBlock().func_176223_P(), breakEvent.getPlayer()));
            }
        }
    }

    static {
        itemGroup = new ItemGroup("compactores"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)((CompactOre)compactOres.values().iterator().next()).getBlock());
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            for (CompactOre ore : compactOres.values()) {
                ore.init1_block();
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ore.getBlock());
            }
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            for (CompactOre ore : compactOres.values()) {
                ore.init2_item();
                itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ore.getBlockItem());
            }
        }

        @SubscribeEvent
        public static void onDecoratorsRegistry(RegistryEvent.Register<Placement<?>> decoratorRegistryEvent) {
            decoratorRegistryEvent.getRegistry().register(new CompactOreWorldGen.AllWithProbability(CompactOreWorldGen.ProbabilityConfig::deserialize).setRegistryName(new ResourceLocation("compactores", "all_with_probability")));
        }
    }
}

