/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOres;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class CompactOresConfig {
    public static Set<CompactOre> loadConfigs() {
        CompactOres.LOGGER.debug("Loading configs!");
        Path configFile = FMLPaths.CONFIGDIR.get().resolve("compactores.toml");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.copy(CompactOresConfig.class.getResourceAsStream("/assets/compactores/default_config.toml"), configFile, new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfig conf = FileConfig.of((Path)configFile);
        conf.load();
        CompactOres.LOGGER.debug("Config: " + configFile);
        Config global = (Config)conf.getOrElse("global", (Object)Config.inMemory());
        double globalCompactOreProbability = (Double)global.getOrElse("compactOreProbability", (Object)0.1);
        int globalMinRolls = (Integer)global.getOrElse("minRolls", (Object)3);
        int globalMaxRolls = (Integer)global.getOrElse("maxRolls", (Object)5);
        CompactOreTexture.setRedrawOreBase((Boolean)global.getOrElse("redrawOreBase", (Object)false));
        HashSet<CompactOre> ores = new HashSet<CompactOre>();
        Map confMap = conf.valueMap();
        CompactOres.LOGGER.debug("Map entries: " + confMap.size());
        for (String s : confMap.keySet()) {
            Config c;
            Object val;
            if (s.equals("global") || !((val = confMap.get(s)) instanceof Config) || !CompactOresConfig.hasString(c = (Config)val, "oreTexture") || !CompactOresConfig.hasString(c, "rockTexture")) continue;
            ResourceLocation baseBlock = CompactOresConfig.parseResourceLocation(s);
            ResourceLocation oreTexture = CompactOresConfig.parseResourceLocation((String)c.get("oreTexture"));
            ResourceLocation rockTexture = CompactOresConfig.parseResourceLocation((String)c.get("rockTexture"));
            float probability = (float)((Double)c.getOrElse("compactOreProbability", (Object)globalCompactOreProbability)).doubleValue();
            int minRolls = (Integer)c.getOrElse("minRolls", (Object)globalMinRolls);
            int maxRolls = (Integer)c.getOrElse("maxRolls", (Object)globalMaxRolls);
            boolean useGetDrops = (Boolean)c.getOrElse("useGetDrops", (Object)false);
            int maxOreLayerColorDiff = (Integer)c.getOrElse("maxOreLayerColorDiff", (Object)50);
            boolean lateGeneration = (Boolean)c.getOrElse("lateGeneration", (Object)false);
            if (ModList.get().isLoaded(baseBlock.func_110624_b())) {
                ores.add(new CompactOre(baseBlock, minRolls, maxRolls, oreTexture, rockTexture, probability, useGetDrops, maxOreLayerColorDiff, lateGeneration));
                continue;
            }
            CompactOres.LOGGER.info("Not creating a compact ore for " + baseBlock + " because the mod " + baseBlock.func_110624_b() + " is not loaded.");
        }
        return ores;
    }

    private static ResourceLocation parseResourceLocation(String str) {
        if (!str.contains(":")) {
            return new ResourceLocation("minecraft", str);
        }
        String namespace = str.split(":")[0];
        String path = str.substring(namespace.length() + 1);
        return new ResourceLocation(namespace, path);
    }

    private static boolean hasString(Config c, String key) {
        return c.contains(key) && c.get(key) instanceof String;
    }
}

