/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOres;
import doublenegation.mods.compactores.InMemoryResourcePack;
import doublenegation.mods.compactores.TextureDumper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class CompactOresResourcePack
implements IPackFinder {
    private Supplier<Map<ResourceLocation, CompactOre>> oreListSupplier;
    private InMemoryResourcePack pack;

    public CompactOresResourcePack(Supplier<Map<ResourceLocation, CompactOre>> oreListSupplier) {
        this.oreListSupplier = oreListSupplier;
    }

    private synchronized InMemoryResourcePack getPack() {
        if (this.pack == null) {
            Map<ResourceLocation, CompactOre> ores = this.oreListSupplier.get();
            CompactOres.LOGGER.info("Generating CompactOre resources for " + ores.size() + " compact ore blocks");
            HashMap<String, Supplier<byte[]>> resPack = new HashMap<String, Supplier<byte[]>>();
            JsonObject packmcmeta = new JsonObject();
            JsonObject packmcmetapack = new JsonObject();
            packmcmetapack.addProperty("pack_format", (Number)4);
            packmcmetapack.addProperty("description", "CompactOres dynamic resources");
            packmcmeta.add("pack", (JsonElement)packmcmetapack);
            byte[] packmcmetaBytes = packmcmeta.toString().getBytes(StandardCharsets.UTF_8);
            resPack.put("pack.mcmeta", () -> packmcmetaBytes);
            BufferedImage packpng = new BufferedImage(16, 16, 1);
            Graphics2D packpngg = packpng.createGraphics();
            packpngg.setColor(Color.BLACK);
            packpngg.fillRect(0, 0, 16, 16);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)packpng, "PNG", baos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] packpngBytes = baos.toByteArray();
            resPack.put("pack.png", () -> packpngBytes);
            this.makeTags(resPack, ores.values());
            for (CompactOre ore : ores.values()) {
                if (ore.getBlock() == null) continue;
                this.makeLootTable(resPack, ore);
                this.makeBlockstate(resPack, ore);
                this.makeBlockModel(resPack, ore);
                this.makeItemModel(resPack, ore);
                this.makeBlockTexture(resPack, ore);
            }
            this.pack = new InMemoryResourcePack(resPack, path -> {
                if (!path.endsWith(".mcmeta")) {
                    return true;
                }
                boolean[] result = new boolean[]{false};
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    String[] split = path.split("/");
                    String filename = split[split.length - 1];
                    String name = filename.substring(0, filename.length() - ".png.mcmeta".length());
                    ResourceLocation loc = new ResourceLocation("compactores", name);
                    CompactOre ore = CompactOres.getFor(loc);
                    ResourceLocation baseTexture = ore.getBaseUnderlyingTexture();
                    ResourceLocation oreTexture = ore.getBaseOreTexture();
                    ResourceLocation baseMeta = new ResourceLocation(baseTexture.func_110624_b(), baseTexture.func_110623_a() + ".mcmeta");
                    ResourceLocation oreMeta = new ResourceLocation(oreTexture.func_110624_b(), oreTexture.func_110623_a() + ".mcmeta");
                    IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
                    result[0] = rm.func_219533_b(baseMeta) || rm.func_219533_b(oreMeta);
                });
                return result[0];
            });
        }
        return this.pack;
    }

    private void makeTags(Map<String, Supplier<byte[]>> resourcePack, Collection<CompactOre> ores) {
        JsonObject tag = new JsonObject();
        tag.addProperty("replace", Boolean.valueOf(false));
        JsonArray values = new JsonArray();
        for (CompactOre ore : ores) {
            values.add(ore.getRegistryName().toString());
        }
        tag.add("values", (JsonElement)values);
        byte[] bytes = tag.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("data/forge/tags/blocks/ores.json", () -> bytes);
        resourcePack.put("data/forge/tags/items/ores.json", () -> bytes);
    }

    private void makeLootTable(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject table = new JsonObject();
        table.addProperty("type", "block");
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        JsonObject rolls = new JsonObject();
        rolls.addProperty("min", (Number)ore.getMinRolls());
        rolls.addProperty("max", (Number)ore.getMaxRolls());
        pool.add("rolls", (JsonElement)rolls);
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "loot_table");
        ResourceLocation baseLootTable = ore.getBaseBlock().func_220068_i();
        entry.addProperty("name", baseLootTable.toString());
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        table.add("pools", (JsonElement)pools);
        byte[] bytes = table.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("data/compactores/loot_tables/" + ore.getBlock().getRegistryName().func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockstate(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject blockstate = new JsonObject();
        JsonObject variants = new JsonObject();
        JsonObject defaultVariant = new JsonObject();
        defaultVariant.addProperty("model", "compactores:block/" + ore.getBlock().getRegistryName().func_110623_a());
        variants.add("", (JsonElement)defaultVariant);
        blockstate.add("variants", (JsonElement)variants);
        byte[] bytes = blockstate.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/compactores/blockstates/" + ore.getBlock().getRegistryName().func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockModel(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "minecraft:block/cube_all");
        JsonObject textures = new JsonObject();
        textures.addProperty("all", "compactores:" + ore.getBlock().getRegistryName().func_110623_a());
        model.add("textures", (JsonElement)textures);
        byte[] bytes = model.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/compactores/models/block/" + ore.getBlock().getRegistryName().func_110623_a() + ".json", () -> bytes);
    }

    private void makeItemModel(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "compactores:block/" + ore.getBlock().getRegistryName().func_110623_a());
        byte[] bytes = model.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/compactores/models/item/" + ore.getBlock().getRegistryName().func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockTexture(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        resourcePack.put("assets/compactores/textures/" + ore.getBlock().getRegistryName().func_110623_a() + ".png", () -> {
            try {
                CompactOreTexture.TextureInfo info = CompactOreTexture.generate(null, ore.getBaseUnderlyingTexture(), ore.getBaseBlock().getRegistryName(), ore.getBaseOreTexture(), ore.getMaxOreLayerColorDiff());
                BufferedImage img = info.generateImage();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "PNG", baos);
                if ("true".equals(System.getProperty("compactores.dumpTextures"))) {
                    TextureDumper.dump(ore, baos.toByteArray());
                }
                return baos.toByteArray();
            }
            catch (Exception e) {
                CompactOres.LOGGER.error("Failed to generate compact ore texture for " + ore.getRegistryName() + ", using missing texture instead.");
                Throwable ex = e;
                do {
                    CompactOres.LOGGER.error("   Caused by " + ex.getClass().getName() + ": " + ex.getMessage());
                } while ((ex = ex.getCause()) != null);
                e.printStackTrace();
                BufferedImage img = new BufferedImage(16, 16, 1);
                Graphics2D g = img.createGraphics();
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, 16, 16);
                g.setColor(Color.MAGENTA);
                g.fillRect(0, 8, 8, 8);
                g.fillRect(8, 0, 8, 8);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)img, "PNG", baos);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                return baos.toByteArray();
            }
        });
        resourcePack.put("assets/compactores/textures/" + ore.getBlock().getRegistryName().func_110623_a() + ".png.mcmeta", () -> {
            try {
                CompactOreTexture.TextureInfo info = CompactOreTexture.generate(null, ore.getBaseUnderlyingTexture(), ore.getBaseBlock().getRegistryName(), ore.getBaseOreTexture(), ore.getMaxOreLayerColorDiff());
                return info.generateMeta().toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                CompactOres.LOGGER.error("Failed to generate compact ore texture for " + ore.getRegistryName() + ", using missing texture instead.");
                Throwable ex = e;
                do {
                    CompactOres.LOGGER.error("   Caused by " + ex.getClass().getName() + ": " + ex.getMessage());
                } while ((ex = ex.getCause()) != null);
                e.printStackTrace();
                throw e;
            }
        });
    }

    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> map, ResourcePackInfo.IFactory<T> iFactory) {
        map.put("CompactOres dynamic resources", ResourcePackInfo.func_195793_a((String)"CompactOres dynamic resources", (boolean)true, this::getPack, iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM));
    }
}

