/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlockItem;
import doublenegation.mods.compactores.CompactOreProperty;
import doublenegation.mods.compactores.CompactOreTileEntity;
import doublenegation.mods.compactores.CompactOres;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ToolType;

public class CompactOreBlock
extends Block {
    public static IProperty<CompactOre> ORE_PROPERTY = new CompactOreProperty<CompactOre>("ore", CompactOre.class, CompactOres.compactOres());

    public CompactOreBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ORE_PROPERTY, (Comparable)CompactOres.compactOres().get(0)));
    }

    Block baseBlock(BlockState state) {
        return Optional.ofNullable(state).filter(st -> st.func_177230_c() == this).map(st -> ((CompactOre)st.func_177229_b(ORE_PROPERTY)).getBaseBlock()).orElse(Blocks.field_150348_b);
    }

    BlockState baseState(BlockState state) {
        return this.baseBlock(state).func_176223_P();
    }

    CompactOre ore(BlockState state, boolean defaultToMissing) {
        return Optional.ofNullable(state).filter(st -> st.func_177230_c() == this).map(st -> (CompactOre)st.func_177229_b(ORE_PROPERTY)).orElse(CompactOres.compactOres().get(defaultToMissing ? 0 : 1));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ORE_PROPERTY});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        state = state == null ? ((CompactOreBlock)CompactOres.COMPACT_ORE.get()).func_176223_P() : state;
        CompactOreBlockItem item = (CompactOreBlockItem)CompactOres.COMPACT_ORE_ITEM.get();
        CompactOre ore = item.findOreForStack(context.func_195996_i());
        return (BlockState)state.func_206870_a(ORE_PROPERTY, (Comparable)ore);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        CompactOre ore = this.ore(state, false);
        return ((CompactOreBlockItem)CompactOres.COMPACT_ORE_ITEM.get()).getStackOfOre(ore, 1);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CompactOreTileEntity(this.ore(state, true));
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.baseBlock(state).getExplosionResistance(this.baseState(state), world, pos, exploder, explosion);
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        Random rand = Optional.of(world.func_217349_x(pos)).map(IChunk::getWorldForge).map(IWorld::func_201674_k).orElse(new Random());
        CompactOre ore = this.ore(state, true);
        int r = ore.getMinRolls() + rand.nextInt(ore.getMaxRolls() - ore.getMinRolls() + 1);
        return this.baseBlock(state).getExpDrop(this.baseState(state), world, pos, fortune, silktouch) * r;
    }

    public int getHarvestLevel(BlockState state) {
        return this.baseBlock(state).getHarvestLevel(this.baseState(state));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.baseBlock(state).getHarvestTool(this.baseState(state));
    }

    public float func_176195_g(BlockState state, IBlockReader p_176195_2_, BlockPos pos) {
        return this.baseBlock(state).func_176195_g(this.baseState(state), p_176195_2_, pos);
    }

    public Material func_149688_o(BlockState state) {
        return this.baseBlock(state).func_149688_o(this.baseState(state));
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader p_180659_2_, BlockPos pos) {
        return this.baseBlock(state).func_180659_g(this.baseState(state), p_180659_2_, pos);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.baseBlock(state).canHarvestBlock(this.baseState(state), world, pos, player);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return this.baseBlock(state).isToolEffective(this.baseState(state), tool);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.baseBlock(state).getSoundType(this.baseState(state), world, pos, entity);
    }

    public SoundType func_220072_p(BlockState state) {
        return this.baseBlock(state).func_220072_p(this.baseState(state));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        CompactOre ore = this.ore(state, true);
        if (ore.isUseGetDrops()) {
            List parentList = super.func_220076_a(state, builder);
            List oreList = ore.getBaseBlock().func_220076_a(this.baseState(state), builder);
            Random rand = builder.func_216018_a().func_201674_k();
            int r = ore.getMinRolls() + rand.nextInt(ore.getMaxRolls() - ore.getMinRolls() + 1);
            for (int i = 0; i < r; ++i) {
                for (ItemStack stack : oreList) {
                    parentList.add(new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E(), stack.func_77978_p()));
                }
            }
            return parentList;
        }
        return super.func_220076_a(state, builder);
    }
}

