/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOres;
import doublenegation.mods.compactores.Utils;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.GameData;

public class CompactOreBlockItem
extends BlockItem {
    public CompactOreBlockItem(Block blockIn) {
        super(blockIn, new Item.Properties().func_200916_a(CompactOres.getItemGroup()));
        this.func_185043_a(new ResourceLocation("compactores", "ore"), (stack, world, holder) -> {
            CompactOre ore = this.findOreForStack(stack);
            return CompactOres.compactOres().indexOf(ore);
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (CompactOre ore : CompactOres.compactOres()) {
                if (!ore.isReal()) continue;
                items.add((Object)this.getStackOfOre(ore, 1));
            }
        }
    }

    public CompactOre findOreForStack(ItemStack stack) {
        String oreName;
        ResourceLocation baseOre;
        CompactOre actualOre;
        CompoundNBT blockEntityTag;
        CompoundNBT tag;
        CompactOre ore = CompactOres.compactOres().get(0);
        if (stack.func_77978_p() != null && (tag = stack.func_77978_p()).func_150297_b("BlockEntityTag", 10) && (blockEntityTag = tag.func_74775_l("BlockEntityTag")).func_150297_b("ore", 8) && (actualOre = CompactOres.getFor(baseOre = Utils.parseResourceLocation(oreName = blockEntityTag.func_74779_i("ore")))) != null) {
            ore = actualOre;
        }
        return ore;
    }

    public ItemStack getStackOfOre(CompactOre ore, int size) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT blockEntityTag = new CompoundNBT();
        blockEntityTag.func_74778_a("ore", ore.getBaseBlockRegistryName().toString());
        tag.func_218657_a("BlockEntityTag", (INBT)blockEntityTag);
        ItemStack is = new ItemStack((IItemProvider)this, size);
        is.func_77982_d(tag);
        return is;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompactOre ore = this.findOreForStack(stack);
        if (!ore.isReal()) {
            return new TranslationTextComponent("block.compactores.missing_ore", new Object[0]);
        }
        ResourceLocation bln = CompactOres.COMPACT_ORE.getId();
        Map blockItemMap = GameData.getBlockItemMap();
        StringTextComponent baseName = ore.getBaseBlock() != null && blockItemMap.containsKey(ore.getBaseBlock()) ? ((Item)blockItemMap.get(ore.getBaseBlock())).func_200295_i(stack) : new StringTextComponent("<unknown>");
        return new TranslationTextComponent("block." + bln.func_110624_b() + "." + bln.func_110623_a(), new Object[]{baseName});
    }
}

