/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.state.Property;
import net.minecraft.util.IStringSerializable;

public class CompactOreProperty<T extends Comparable<T> & IStringSerializable>
extends Property<T> {
    private final ImmutableSet<T> allowedValues;
    private final Map<String, T> nameToValue = Maps.newHashMap();

    public CompactOreProperty(String name, Class<T> valueClass, Collection<T> allowedValues) {
        super(name, valueClass);
        this.allowedValues = ImmutableSet.copyOf(allowedValues);
        for (Comparable t : allowedValues) {
            String s = ((IStringSerializable)t).func_176610_l();
            if (this.nameToValue.containsKey(s)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + s + "'");
            }
            this.nameToValue.put(s, t);
        }
    }

    public Collection<T> func_177700_c() {
        return this.allowedValues;
    }

    public Optional<T> func_185929_b(String value) {
        return Optional.ofNullable(this.nameToValue.get(value));
    }

    public String func_177702_a(T value) {
        return ((IStringSerializable)value).func_176610_l();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof CompactOreProperty && super.equals(p_equals_1_)) {
            CompactOreProperty enumproperty = (CompactOreProperty)((Object)p_equals_1_);
            return this.allowedValues.equals(enumproperty.allowedValues) && this.nameToValue.equals(enumproperty.nameToValue);
        }
        return false;
    }

    public int func_206906_c() {
        int i = super.func_206906_c();
        i = 31 * i + this.allowedValues.hashCode();
        i = 31 * i + this.nameToValue.hashCode();
        return i;
    }
}

