/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class InMemoryResourcePack
implements IResourcePack {
    private String name;
    private Map<String, Supplier<byte[]>> data;
    private Predicate<String> doesActuallyExist;

    public InMemoryResourcePack(String name, Map<String, Supplier<byte[]>> data, Predicate<String> doesActuallyExist) {
        this.name = name;
        this.data = data;
        this.doesActuallyExist = doesActuallyExist;
    }

    private InputStream s(Supplier<byte[]> data) {
        return new ByteArrayInputStream(data.get());
    }

    public InputStream func_195763_b(String fileName) {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Must be a root filename");
        }
        if (this.data.containsKey(fileName)) {
            return this.s(this.data.get(fileName));
        }
        return null;
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        String path = type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a();
        if (this.data.containsKey(path)) {
            return this.s(this.data.get(path));
        }
        throw new FileNotFoundException(type + ", " + location);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        return this.data.keySet().stream().filter(s -> s.contains("/")).filter(this.doesActuallyExist).map(s -> {
            String[] tk = s.split("/");
            String typeStr = tk[0];
            String namespace = tk[1];
            String path = s.substring(typeStr.length() + namespace.length() + 2);
            String filename = tk[tk.length - 1];
            return new String[]{typeStr, namespace, path, filename};
        }).filter(tk -> tk[0].equals(type.func_198956_a())).filter(tk -> tk[1].startsWith(namespaceIn)).filter(tk -> tk[2].startsWith(pathIn)).filter(tk -> filterIn.test(tk[3])).filter(tk -> tk[2].split("/").length - 1 <= maxDepthIn).map(tk -> new ResourceLocation(tk[1], tk[2])).collect(Collectors.toSet());
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        String path = type.func_198956_a() + "/" + location.func_110624_b() + "/" + location.func_110623_a();
        return this.data.containsKey(path) && this.doesActuallyExist.test(path);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return this.data.keySet().stream().filter(s -> s.startsWith(type.func_198956_a())).map(s -> s.split("/")[1]).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        try (InputStream inputstream = this.func_195763_b("pack.mcmeta");){
            Object object = ResourcePack.func_195770_a(deserializer, (InputStream)inputstream);
            return (T)object;
        }
        catch (FileNotFoundException | RuntimeException var16) {
            return null;
        }
    }

    public String func_195762_a() {
        return this.name;
    }

    public void close() {
    }

    public boolean isHidden() {
        return true;
    }
}

