/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableList;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigFile;
import doublenegation.mods.compactores.config.ConfigFileManager;
import doublenegation.mods.compactores.config.OreBuilder;
import doublenegation.mods.compactores.config.OreConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<CompactOre> loadOres() {
        LOGGER.info("Loading compactores configuration...");
        ConfigFileManager cfm = new ConfigFileManager();
        try {
            Object f;
            cfm.load();
            ConfigFile globalDefinition = null;
            ConfigFile globalCustomization = null;
            HashMap<ResourceLocation, Object> definitions = new HashMap<ResourceLocation, Object>();
            HashMap<ResourceLocation, Object> customizations = new HashMap<ResourceLocation, Object>();
            for (FileConfig cfg : cfm.getDefinitionConfigs()) {
                f = new ConfigFile(cfg, ConfigFile.Type.DEFINITION);
                if (((ConfigFile)f).hasGlobalConfig()) {
                    if (globalDefinition == null) {
                        globalDefinition = f;
                    } else {
                        LOGGER.fatal("Multiple global definition configs found:");
                        LOGGER.fatal("\t" + globalDefinition.getType().getDirname() + "/" + globalDefinition.getFilenameNamespace() + ".toml");
                        LOGGER.fatal("\t" + ((ConfigFile)f).getType().getDirname() + "/" + ((ConfigFile)f).getFilenameNamespace() + ".toml");
                        throw new IllegalStateException("Multiple global definition configs found - aborting!");
                    }
                }
                for (ResourceLocation ore : ((ConfigFile)f).getOres()) {
                    if (!definitions.containsKey(ore)) {
                        definitions.put(ore, f);
                        continue;
                    }
                    ConfigFile g = (ConfigFile)definitions.get(ore);
                    LOGGER.fatal("Ore " + ore + " is defined multiple times:");
                    LOGGER.fatal("\tin " + g.getType().getDirname() + "/" + g.getFilenameNamespace() + ".toml");
                    LOGGER.fatal("\tin " + ((ConfigFile)f).getType().getDirname() + "/" + ((ConfigFile)f).getFilenameNamespace() + ".toml");
                    throw new IllegalStateException("Ore " + ore + " is defined multiple times - aborting!");
                }
            }
            for (FileConfig cfg : cfm.getCustomizationConfigs()) {
                f = new ConfigFile(cfg, ConfigFile.Type.CUSTOMIZATION);
                if (((ConfigFile)f).hasGlobalConfig()) {
                    if (globalCustomization == null) {
                        globalCustomization = f;
                    } else {
                        LOGGER.fatal("Multiple global customizations configs found:");
                        LOGGER.fatal("\t" + globalCustomization.getType().getDirname() + "/" + globalCustomization.getFilenameNamespace() + ".toml");
                        LOGGER.fatal("\t" + ((ConfigFile)f).getType().getDirname() + "/" + ((ConfigFile)f).getFilenameNamespace() + ".toml");
                        throw new IllegalStateException("Multiple global customization configs found - aborting!");
                    }
                }
                for (ResourceLocation ore : ((ConfigFile)f).getOres()) {
                    if (!definitions.containsKey(ore)) {
                        LOGGER.warn("Customization config found for undefined ore " + ore + " - ignoring!");
                        continue;
                    }
                    if (!customizations.containsKey(ore)) {
                        customizations.put(ore, f);
                        continue;
                    }
                    ConfigFile g = (ConfigFile)customizations.get(ore);
                    LOGGER.fatal("Ore " + ore + " is defined customized times:");
                    LOGGER.fatal("\tin " + g.getType().getDirname() + "/" + g.getFilenameNamespace() + ".toml");
                    LOGGER.fatal("\tin " + ((ConfigFile)f).getType().getDirname() + "/" + ((ConfigFile)f).getFilenameNamespace() + ".toml");
                    throw new IllegalStateException("Ore " + ore + " is customized multiple times - aborting!");
                }
            }
            if (globalDefinition != null) {
                Optional.ofNullable(globalDefinition.getGlobalConfigValue("generateTexture")).filter(v -> v instanceof Boolean).ifPresent(v -> OreBuilder.setGlobalGenerateTexture((Boolean)v));
                Optional.ofNullable(globalDefinition.getGlobalConfigValue("maxOreLayerColorDiff")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMaxOreLayerColorDiff((Integer)v));
                Optional.ofNullable(globalDefinition.getGlobalConfigValue("redrawOreBase")).filter(v -> v instanceof Boolean).ifPresent(v -> CompactOreTexture.setRedrawOreBase((Boolean)v));
            }
            if (globalCustomization != null) {
                Optional.ofNullable(globalCustomization.getGlobalConfigValue("minRolls")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMinRolls((Integer)v));
                Optional.ofNullable(globalCustomization.getGlobalConfigValue("maxRolls")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMaxRolls((Integer)v));
                Optional.ofNullable(globalCustomization.getGlobalConfigValue("spawnProbability")).filter(v -> v instanceof Number).ifPresent(v -> OreBuilder.setGlobalSpawnProbability((float)((Double)v).doubleValue()));
            }
            OreBuilderFactoryProvider obfp = new OreBuilderFactoryProvider();
            ArrayList<CompactOre> ores = new ArrayList<CompactOre>();
            for (ResourceLocation orename : definitions.keySet()) {
                OreConfigHolder och = new OreConfigHolder(orename, obfp);
                och.setDefinitionConfig((ConfigFile)definitions.get(orename));
                if (customizations.containsKey(orename)) {
                    och.setCustomizationConfig((ConfigFile)customizations.get(orename));
                } else {
                    LOGGER.warn("No customization config specified for ore " + orename + " - if you do not intend to customize the ore, it is recommended to specify an empty customization block anyways");
                }
                try {
                    ores.add(och.buildOre());
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Failed to load ore " + orename + ": " + ex.getClass().getName() + ": " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            ArrayList<CompactOre> enabledOres = new ArrayList<CompactOre>();
            HashSet<String> activeOreMods = new HashSet<String>();
            HashSet<String> inactiveOreMods = new HashSet<String>();
            ModList modList = ModList.get();
            for (CompactOre ore : ores) {
                String modid = ore.getBaseBlockRegistryName().func_110624_b();
                if (modList.isLoaded(modid)) {
                    enabledOres.add(ore);
                    activeOreMods.add(modid);
                    continue;
                }
                inactiveOreMods.add(modid);
            }
            LOGGER.info("Successfully loaded " + ores.size() + " compact ores for a total of " + (activeOreMods.size() + inactiveOreMods.size()) + " mods.");
            LOGGER.info("\t" + enabledOres.size() + " ores for " + activeOreMods.size() + " mods are active.");
            LOGGER.info("\t" + (ores.size() - enabledOres.size()) + " ores for " + inactiveOreMods.size() + " mods will not be enabled because their mod is not loaded.");
            enabledOres.sort(CompactOre::compareTo);
            enabledOres.forEach(o -> LOGGER.debug((Object)o.getBaseBlockRegistryName()));
            return enabledOres;
        }
        catch (Exception e) {
            cfm.handleConfigLoadingFailed(e);
            ResourceLocation stone = new ResourceLocation("minecraft", "stone");
            ResourceLocation dirt = new ResourceLocation("minecraft", "dirt");
            ResourceLocation stoneTex = new ResourceLocation("minecraft", "block/stone");
            return new ArrayList<CompactOre>((Collection<CompactOre>)ImmutableList.of((Object)new CompactOre(stone, 1, 1, stoneTex, stoneTex, 0.0f, -1, false, true, false), (Object)new CompactOre(dirt, 1, 1, stoneTex, stoneTex, 0.0f, -1, false, true, false)));
        }
    }

    private static class OreBuilderFactoryProvider
    implements BiFunction<ConfigFile, ConfigFile, OreBuilder> {
        private Map<ConfigFile, Map<ConfigFile, OreBuilder.Factory>> factories = new HashMap<ConfigFile, Map<ConfigFile, OreBuilder.Factory>>();

        private OreBuilderFactoryProvider() {
        }

        @Override
        public synchronized OreBuilder apply(ConfigFile definitionConfig, ConfigFile customizationConfig) {
            Map<ConfigFile, OreBuilder.Factory> factoryMap;
            if (!this.factories.containsKey(definitionConfig)) {
                this.factories.put(definitionConfig, new HashMap());
            }
            if ((factoryMap = this.factories.get(definitionConfig)).containsKey(customizationConfig)) {
                return factoryMap.get(customizationConfig).create();
            }
            OreBuilder.Factory fact = this.createFactory(definitionConfig, customizationConfig);
            factoryMap.put(customizationConfig, fact);
            return fact.create();
        }

        private OreBuilder.Factory createFactory(ConfigFile definitionConfig, ConfigFile customizationConfig) {
            OreBuilder.Factory fact = OreBuilder.Factory.createFactory();
            if (definitionConfig.hasLocalConfig()) {
                fact.generateTexture((Boolean)definitionConfig.getLocalConfigValue("generateTexture")).maxOreLayerColorDiff((Integer)definitionConfig.getLocalConfigValue("maxOreLayerColorDiff")).oreTexture(Utils.parseResourceLocationExtra((String)definitionConfig.getLocalConfigValue("oreTexture"), definitionConfig.getFilenameNamespace())).rockTexture(Utils.parseResourceLocationExtra((String)definitionConfig.getLocalConfigValue("rockTexture"), definitionConfig.getFilenameNamespace())).lateGeneration((Boolean)definitionConfig.getLocalConfigValue("lateGeneration")).useGetDrops((Boolean)definitionConfig.getLocalConfigValue("useGetDrops"));
            }
            if (customizationConfig != null && customizationConfig.hasLocalConfig()) {
                fact.minRolls((Integer)customizationConfig.getLocalConfigValue("minRolls")).maxRolls((Integer)customizationConfig.getLocalConfigValue("maxRolls")).spawnProbability((Float)customizationConfig.getLocalConfigValue("spawnProbability"));
            }
            return fact;
        }
    }
}

