/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOreBlockItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompactOre
implements Comparable<CompactOre>,
IStringSerializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"compactores");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"compactores");
    private static Set<String> usedResourceNames;
    private String resourceName;
    private ResourceLocation baseBlockLoc;
    private Block baseBlock;
    private int minRolls;
    private int maxRolls;
    private ResourceLocation baseOreTexture;
    private ResourceLocation baseUnderlyingTexture;
    private float spawnProbability;
    private int maxOreLayerColorDiff;
    private boolean lateGeneration;
    private boolean generateTexture;
    private boolean useGetDrops;
    private RegistryObject<CompactOreBlock> compactOreBlock;
    private ResourceLocation compactOreBlockRegistryName;
    private RegistryObject<CompactOreBlockItem> compactOreBlockItem;

    public CompactOre(ResourceLocation baseBlockLoc, int minRolls, int maxRolls, ResourceLocation baseOreTexture, ResourceLocation baseUnderlyingTexture, float spawnProbability, int maxOreLayerColorDiff, boolean lateGeneration, boolean generateTexture, boolean useGetDrops) {
        this.baseBlockLoc = baseBlockLoc;
        this.minRolls = minRolls;
        this.maxRolls = maxRolls;
        this.baseOreTexture = baseOreTexture == null ? null : new ResourceLocation(baseOreTexture.func_110624_b(), "textures/" + baseOreTexture.func_110623_a() + ".png");
        this.baseUnderlyingTexture = baseUnderlyingTexture == null ? null : new ResourceLocation(baseUnderlyingTexture.func_110624_b(), "textures/" + baseUnderlyingTexture.func_110623_a() + ".png");
        this.spawnProbability = spawnProbability;
        this.maxOreLayerColorDiff = maxOreLayerColorDiff;
        this.lateGeneration = lateGeneration;
        this.generateTexture = generateTexture;
        this.useGetDrops = useGetDrops;
        String resourceName = baseBlockLoc.toString().replace(":", "__");
        while (usedResourceNames.contains(resourceName)) {
            resourceName = resourceName + "_";
        }
        this.resourceName = resourceName;
        usedResourceNames.add(resourceName);
        this.compactOreBlockRegistryName = new ResourceLocation("compactores", "compactore__" + this.resourceName);
        this.compactOreBlock = BLOCKS.register(this.compactOreBlockRegistryName.func_110623_a(), () -> new CompactOreBlock(this));
        this.compactOreBlockItem = ITEMS.register(this.compactOreBlockRegistryName.func_110623_a(), () -> new CompactOreBlockItem(this));
    }

    public ResourceLocation getBaseBlockRegistryName() {
        return this.baseBlockLoc;
    }

    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            this.baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.baseBlockLoc);
            if (this.baseBlock == Blocks.field_150350_a) {
                LOGGER.error("Block " + this.baseBlockLoc + " does not exist - failed to create compact ore");
                this.baseBlock = null;
            }
        }
        return this.baseBlock;
    }

    public int getMinRolls() {
        return this.minRolls;
    }

    public int getMaxRolls() {
        return this.maxRolls;
    }

    public ResourceLocation getBaseOreTexture() {
        return this.baseOreTexture;
    }

    public ResourceLocation getBaseUnderlyingTexture() {
        return this.baseUnderlyingTexture;
    }

    public float getSpawnProbability() {
        return this.spawnProbability;
    }

    public int getMaxOreLayerColorDiff() {
        return this.maxOreLayerColorDiff;
    }

    public boolean isLateGeneration() {
        return this.lateGeneration;
    }

    public boolean isGenerateTexture() {
        return this.generateTexture;
    }

    public boolean isUseGetDrops() {
        return this.useGetDrops;
    }

    public ResourceLocation name() {
        return this.compactOreBlockRegistryName;
    }

    public CompactOreBlock getCompactOreBlock() {
        return (CompactOreBlock)this.compactOreBlock.orElse(null);
    }

    public CompactOreBlockItem getCompactOreBlockItem() {
        return (CompactOreBlockItem)this.compactOreBlockItem.orElse(null);
    }

    @Override
    public int compareTo(CompactOre compactOre) {
        ModList.get().getMods();
        if (this.baseBlockLoc.func_110624_b().equals(compactOre.baseBlockLoc.func_110624_b())) {
            return this.baseBlockLoc.func_110623_a().compareTo(compactOre.baseBlockLoc.func_110623_a());
        }
        List modList = ModList.get().getMods();
        int thisIndex = -1;
        int otherIndex = -1;
        for (int i = 0; i < modList.size(); ++i) {
            String modId = ((ModInfo)modList.get(i)).getModId();
            if (this.baseBlockLoc.func_110624_b().equals(modId)) {
                thisIndex = i;
            } else if (compactOre.baseBlockLoc.func_110624_b().equals(modId)) {
                otherIndex = i;
            }
            if (thisIndex != -1 && otherIndex != -1) break;
        }
        return thisIndex - otherIndex;
    }

    public String func_176610_l() {
        return this.resourceName;
    }

    static {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        usedResourceNames = new HashSet<String>();
    }
}

