/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.mojang.serialization.Codec;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOres;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.SimplePlacement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompactOreWorldGen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Set<ConfiguredFeature<?, ?>> normalFeatures = new HashSet();
    private static Set<ConfiguredFeature<?, ?>> lateFeatures = new HashSet();

    public static void init(List<CompactOre> ores) {
        HashMap normalGeneratingOresByProbability = new HashMap();
        HashMap lateGeneratingOresByProbability = new HashMap();
        for (CompactOre ore : ores) {
            HashMap m;
            if (ore.getBaseBlock() == null) continue;
            HashMap<Float, HashSet<Object>> hashMap = m = ore.isLateGeneration() ? lateGeneratingOresByProbability : normalGeneratingOresByProbability;
            if (!m.containsKey(Float.valueOf(ore.getSpawnProbability()))) {
                m.put(Float.valueOf(ore.getSpawnProbability()), new HashSet());
            }
            ((Set)m.get(Float.valueOf(ore.getSpawnProbability()))).add(ore);
        }
        normalFeatures = normalGeneratingOresByProbability.keySet().stream().map(prob -> CompactOreWorldGen.make(prob.floatValue(), (Set)normalGeneratingOresByProbability.get(prob))).collect(Collectors.toSet());
        lateFeatures = lateGeneratingOresByProbability.keySet().stream().map(prob -> CompactOreWorldGen.make(prob.floatValue(), (Set)lateGeneratingOresByProbability.get(prob))).collect(Collectors.toSet());
        LOGGER.info("Registering " + (normalFeatures.size() + lateFeatures.size()) + " world generation features (" + normalFeatures.size() + " normal, " + lateFeatures.size() + " late)");
    }

    public static void register(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        normalFeatures.forEach(feature -> generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature));
        lateFeatures.forEach(feature -> generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, feature));
    }

    private static ConfiguredFeature<?, ?> make(float prob, Set<CompactOre> ores) {
        return ((MultiReplaceBlockFeature)CompactOres.MULTI_REPLACE_BLOCK.get()).func_225566_b_(new MultiReplaceBlockConfig(ores.stream().collect(Collectors.toMap(ore -> ore.getBaseBlock().func_176223_P(), ore -> ore.getCompactOreBlock().func_176223_P())))).func_227228_a_(((AllWithProbability)CompactOres.ALL_WITH_PROBABILITY.get()).func_227446_a_(new ProbabilityConfig(prob)));
    }

    public static class MultiReplaceBlockFeature
    extends Feature<MultiReplaceBlockConfig> {
        public MultiReplaceBlockFeature(Codec<MultiReplaceBlockConfig> arg0) {
            super(arg0);
        }

        public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, MultiReplaceBlockConfig config) {
            if (config.replacementMap.containsKey(worldIn.func_180495_p(pos))) {
                worldIn.func_180501_a(pos, config.replacementMap.get(worldIn.func_180495_p(pos)), 2);
            }
            return true;
        }
    }

    public static class MultiReplaceBlockConfig
    implements IFeatureConfig {
        public static final Codec<MultiReplaceBlockConfig> codec = Codec.unboundedMap((Codec)BlockState.field_235877_b_, (Codec)BlockState.field_235877_b_).fieldOf("replacementMap").xmap(MultiReplaceBlockConfig::new, config -> config.replacementMap).codec();
        public final Map<BlockState, BlockState> replacementMap;

        public MultiReplaceBlockConfig(Map<BlockState, BlockState> replacementMap) {
            this.replacementMap = Collections.unmodifiableMap(replacementMap);
        }
    }

    public static class AllWithProbability
    extends SimplePlacement<ProbabilityConfig> {
        public AllWithProbability(Codec<ProbabilityConfig> p_i51362_1_) {
            super(p_i51362_1_);
        }

        protected Stream<BlockPos> getPositions(Random random, ProbabilityConfig probabilityConfig, BlockPos blockPos) {
            Stream.Builder<BlockPos> builder = Stream.builder();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        if (!(random.nextFloat() <= probabilityConfig.probability)) continue;
                        builder.add(blockPos.func_177982_a(x, y, z));
                    }
                }
            }
            return builder.build();
        }
    }

    public static class ProbabilityConfig
    implements IPlacementConfig {
        public static final Codec<ProbabilityConfig> codec = Codec.FLOAT.fieldOf("probability").xmap(ProbabilityConfig::new, config -> Float.valueOf(config.probability)).codec();
        public final float probability;

        public ProbabilityConfig(float probability) {
            this.probability = probability;
        }
    }
}

