/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOreWorldGen;
import doublenegation.mods.compactores.CompactOresResourcePack;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.resources.IPackFinder;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compactores")
public class CompactOres {
    public static final String MODID = "compactores";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Placement<?>> DECORATORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DECORATORS, (String)"compactores");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"compactores");
    public static final RegistryObject<CompactOreWorldGen.AllWithProbability> ALL_WITH_PROBABILITY = DECORATORS.register("all_with_probability", () -> new CompactOreWorldGen.AllWithProbability(CompactOreWorldGen.ProbabilityConfig.codec));
    public static final RegistryObject<CompactOreWorldGen.MultiReplaceBlockFeature> MULTI_REPLACE_BLOCK = FEATURES.register("multi_replace_block", () -> new CompactOreWorldGen.MultiReplaceBlockFeature(CompactOreWorldGen.MultiReplaceBlockConfig.codec));
    private static List<CompactOre> compactOres;
    private static CompactOresResourcePack resourcePack;
    private static Utils.ReturningScreen loadFinishScreen;
    private static Timer loadFinishTimer;
    private static ItemGroup itemGroup;

    public CompactOres() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::startServer);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockBroken);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onBiomeLoading);
        compactOres = ConfigLoader.loadOres();
        DECORATORS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        resourcePack = new CompactOresResourcePack(CompactOres::compactOres);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            LOGGER.info("Attaching CompactOre resources to the Minecraft client");
            Minecraft.func_71410_x().func_195548_H().addPackFinder((IPackFinder)resourcePack);
            CompactOreTexture.registerCacheInvalidator();
        });
    }

    public static List<CompactOre> compactOres() {
        return compactOres;
    }

    public static CompactOre getFor(ResourceLocation baseBlockLoc) {
        for (CompactOre ore : compactOres) {
            if (!ore.getBaseBlockRegistryName().equals((Object)baseBlockLoc)) continue;
            return ore;
        }
        return null;
    }

    public static CompactOre getForResourceName(String resourceName) {
        for (CompactOre ore : compactOres) {
            if (!ore.func_176610_l().equals(resourceName)) continue;
            return ore;
        }
        return null;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CompactOreWorldGen.init(compactOres);
    }

    private void onBiomeLoading(BiomeLoadingEvent event) {
        CompactOreWorldGen.register(event);
    }

    public static ItemGroup getItemGroup() {
        return itemGroup;
    }

    public void startServer(FMLServerAboutToStartEvent event) {
        Tag oreItemTag;
        LOGGER.info("Attaching CompactOre resources to the Minecraft server");
        event.getServer().func_195561_aH().addPackFinder((IPackFinder)resourcePack);
        LOGGER.info("Injecting post-first-load CompactOres server data into the Minecraft Server");
        LootTableManager ltm = event.getServer().getDataPackRegistries().func_240965_c_();
        Map tables = ltm.func_215304_a().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((LootTableManager)ltm).func_186521_a(arg_0)));
        for (CompactOre ore : compactOres) {
            LootTable table = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)new RandomValueRange((float)ore.getMinRolls(), (float)ore.getMaxRolls())).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ore.getBaseBlock().func_220068_i()))).func_216038_b();
            tables.put(ore.getCompactOreBlock().func_220068_i(), table);
        }
        ObfuscationReflectionHelper.setPrivateValue(LootTableManager.class, (Object)ltm, (Object)ImmutableMap.copyOf(tables), (String)"field_186527_c");
        Tag oreBlockTag = this.findBaseTag((ITag)ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)new ResourceLocation("forge", "ores")));
        if (oreBlockTag != null) {
            HashSet oreBlockTagContents = new HashSet(oreBlockTag.field_241283_c_);
            oreBlockTagContents.addAll(compactOres.stream().map(CompactOre::getCompactOreBlock).collect(Collectors.toSet()));
            oreBlockTag.field_241283_c_ = oreBlockTagContents;
            ArrayList oreBlockTagImmutableContents = new ArrayList(oreBlockTag.field_241282_b_);
            oreBlockTagImmutableContents.addAll(compactOres.stream().map(CompactOre::getCompactOreBlock).collect(Collectors.toList()));
            oreBlockTag.field_241282_b_ = ImmutableList.copyOf(oreBlockTagImmutableContents);
        }
        if ((oreItemTag = this.findBaseTag((ITag)ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)new ResourceLocation("forge", "ores")))) != null) {
            HashSet oreItemTagContents = new HashSet(oreItemTag.field_241283_c_);
            oreItemTagContents.addAll(compactOres.stream().map(CompactOre::getCompactOreBlockItem).collect(Collectors.toSet()));
            oreItemTag.field_241283_c_ = oreItemTagContents;
            ArrayList oreItemTagImmutableContents = new ArrayList(oreItemTag.field_241282_b_);
            oreItemTagImmutableContents.addAll(compactOres.stream().map(CompactOre::getCompactOreBlockItem).collect(Collectors.toList()));
            oreItemTag.field_241282_b_ = ImmutableList.copyOf(oreItemTagImmutableContents);
        }
    }

    private <T> Tag<T> findBaseTag(ITag<T> tag) {
        try {
            Class<?> namedTagClass = Class.forName("net.minecraft.tags.TagRegistry$NamedTag");
            if (tag instanceof Tag) {
                return (Tag)tag;
            }
            if (namedTagClass.isAssignableFrom(tag.getClass())) {
                Field f = ObfuscationReflectionHelper.findField(namedTagClass, (String)"field_232942_b_");
                f.setAccessible(true);
                ITag baseTag = (ITag)f.get(tag);
                return this.findBaseTag(baseTag);
            }
            LOGGER.error("Unexpected problem encountered when trying to inject compact ore tags - compact ores wil not be tagged");
            return null;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            LOGGER.error("Unexpected problem encountered when trying to inject compact ore tags - compact ores will not be tagged", e);
            return null;
        }
    }

    public void onBlockBroken(BlockEvent.BreakEvent breakEvent) {
        if (!(breakEvent.getState().func_177230_c() instanceof CompactOreBlock)) {
            return;
        }
        CompactOre ore = ((CompactOreBlock)breakEvent.getState().func_177230_c()).getOre();
        int numEvents = ore.getMinRolls() + breakEvent.getWorld().func_201674_k().nextInt(ore.getMaxRolls() - ore.getMinRolls() + 1);
        for (int i = 0; i < numEvents; ++i) {
            MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((World)breakEvent.getWorld(), breakEvent.getPos(), ore.getBaseBlock().func_176223_P(), breakEvent.getPlayer()));
        }
    }

    public static void setLoadFinishScreen(Object screen) {
        if (!(screen instanceof Utils.ReturningScreen)) {
            return;
        }
        loadFinishScreen = (Utils.ReturningScreen)((Object)screen);
        if (loadFinishTimer == null) {
            loadFinishTimer = new Timer();
            loadFinishTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen) {
                        LOGGER.info("Main menu entered - switching to Compact Ores config notification screen");
                        loadFinishTimer.cancel();
                        Minecraft.func_71410_x().func_212871_a_(() -> {
                            Screen returnScreen = Minecraft.func_71410_x().field_71462_r;
                            loadFinishScreen.setReturnTarget(returnScreen);
                            Minecraft.func_71410_x().func_147108_a((Screen)loadFinishScreen);
                        });
                    }
                }
            }, 100L, 100L);
        }
    }

    static {
        itemGroup = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)(compactOres.size() > 0 ? ((CompactOre)compactOres.get(0)).getCompactOreBlockItem() : Items.field_221574_b), 1);
            }
        };
    }
}

