/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOres;
import doublenegation.mods.compactores.InMemoryResourcePack;
import doublenegation.mods.compactores.TextureDumper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompactOresResourcePack
implements IPackFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PACK_NAME = "CompactOres dynamic resources";
    private Supplier<List<CompactOre>> oreListSupplier;
    private Map<String, Supplier<byte[]>> packData;
    private InMemoryResourcePack pack;

    public CompactOresResourcePack(Supplier<List<CompactOre>> oreListSupplier) {
        this.oreListSupplier = oreListSupplier;
    }

    private synchronized InMemoryResourcePack getPack() {
        if (this.pack == null) {
            this.packData = new HashMap<String, Supplier<byte[]>>();
            this.generatePack(this.packData);
            this.pack = new InMemoryResourcePack(PACK_NAME, this.packData, path -> {
                if (!path.endsWith(".mcmeta")) {
                    return true;
                }
                return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> {
                    String[] split = path.split("/");
                    String filename = split[split.length - 1];
                    if (!filename.startsWith("compactore__") || !filename.endsWith(".png.mcmeta")) {
                        return false;
                    }
                    String name = filename.substring("compactore__".length(), filename.length() - ".png.mcmeta".length());
                    CompactOre ore = CompactOres.getForResourceName(name);
                    if (ore == null) {
                        return false;
                    }
                    ResourceLocation baseTexture = ore.getBaseUnderlyingTexture();
                    ResourceLocation oreTexture = ore.getBaseOreTexture();
                    if (!ore.isGenerateTexture() || baseTexture == null || oreTexture == null) {
                        return false;
                    }
                    ResourceLocation baseMeta = new ResourceLocation(baseTexture.func_110624_b(), baseTexture.func_110623_a() + ".mcmeta");
                    ResourceLocation oreMeta = new ResourceLocation(oreTexture.func_110624_b(), oreTexture.func_110623_a() + ".mcmeta");
                    IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
                    return rm.func_219533_b(baseMeta) || rm.func_219533_b(oreMeta);
                }, () -> () -> false);
            });
        }
        return this.pack;
    }

    private void generatePack(Map<String, Supplier<byte[]>> resPack) {
        boolean continueLoading;
        List<CompactOre> ores = this.oreListSupplier.get();
        LOGGER.info("Generating CompactOre resources for " + ores.size() + " compact ore blocks");
        JsonObject packmcmeta = new JsonObject();
        JsonObject packmcmetapack = new JsonObject();
        packmcmetapack.addProperty("pack_format", (Number)4);
        packmcmetapack.addProperty("description", PACK_NAME);
        packmcmeta.add("pack", (JsonElement)packmcmetapack);
        byte[] packmcmetaBytes = packmcmeta.toString().getBytes(StandardCharsets.UTF_8);
        resPack.put("pack.mcmeta", () -> packmcmetaBytes);
        BufferedImage packpng = new BufferedImage(16, 16, 1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)packpng, "PNG", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] packpngBytes = baos.toByteArray();
        resPack.put("pack.png", () -> packpngBytes);
        try {
            continueLoading = ores.size() > 0 && ores.get(0).getCompactOreBlock() != null;
        }
        catch (NullPointerException e) {
            continueLoading = false;
        }
        if (continueLoading) {
            this.makeOreTags(resPack, ores);
            for (CompactOre ore : ores) {
                if (ore.getBaseBlock() == null || ore.getCompactOreBlock() == null) continue;
                this.makeLootTable(resPack, ore);
                this.makeBlockstate(resPack, ore);
                this.makeBlockModel(resPack, ore);
                this.makeBlockTexture(resPack, ore);
                this.makeItemModel(resPack, ore);
            }
        }
    }

    private void makeLootTable(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject table = new JsonObject();
        table.addProperty("type", "block");
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        JsonObject rolls = new JsonObject();
        rolls.addProperty("min", (Number)ore.getMinRolls());
        rolls.addProperty("max", (Number)ore.getMaxRolls());
        pool.add("rolls", (JsonElement)rolls);
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "loot_table");
        entry.addProperty("name", ore.getBaseBlock().func_220068_i().toString());
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        table.add("pools", (JsonElement)pools);
        byte[] bytes = table.toString().getBytes(StandardCharsets.UTF_8);
        ResourceLocation loc = ore.getCompactOreBlock().func_220068_i();
        resourcePack.put("data/" + loc.func_110624_b() + "/loot_tables/" + loc.func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockstate(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject blockstate = new JsonObject();
        JsonObject variants = new JsonObject();
        JsonObject variant = new JsonObject();
        variant.addProperty("model", ore.name().func_110624_b() + ":block/" + ore.name().func_110623_a());
        variants.add("", (JsonElement)variant);
        blockstate.add("variants", (JsonElement)variants);
        byte[] bytes = blockstate.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/" + ore.name().func_110624_b() + "/blockstates/" + ore.name().func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockModel(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "minecraft:block/cube_all");
        JsonObject textures = new JsonObject();
        textures.addProperty("all", ore.name().func_110624_b() + ":" + ore.name().func_110623_a());
        model.add("textures", (JsonElement)textures);
        byte[] bytes = model.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/" + ore.name().func_110624_b() + "/models/block/" + ore.name().func_110623_a() + ".json", () -> bytes);
    }

    private void makeItemModel(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", ore.name().func_110624_b() + ":block/" + ore.name().func_110623_a());
        byte[] bytes = model.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("assets/" + ore.name().func_110624_b() + "/models/item/" + ore.name().func_110623_a() + ".json", () -> bytes);
    }

    private void makeBlockTexture(Map<String, Supplier<byte[]>> resourcePack, CompactOre ore) {
        if (ore.isGenerateTexture()) {
            resourcePack.put("assets/" + ore.name().func_110624_b() + "/textures/" + ore.name().func_110623_a() + ".png", () -> {
                try {
                    CompactOreTexture.TextureInfo info = CompactOreTexture.generate(null, ore.getBaseUnderlyingTexture(), ore.getBaseBlockRegistryName(), ore.getBaseOreTexture(), ore.getMaxOreLayerColorDiff());
                    BufferedImage img = info.generateImage();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)img, "PNG", baos);
                    if ("true".equals(System.getProperty("compactores.dumpTextures"))) {
                        TextureDumper.dump(ore, baos.toByteArray());
                    }
                    return baos.toByteArray();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate compact ore texture for " + ore.name().func_110623_a() + ", using missing texture instead.");
                    this.logExceptionCauseList(e);
                    BufferedImage img = new BufferedImage(16, 16, 1);
                    Graphics2D g = img.createGraphics();
                    g.setColor(Color.BLACK);
                    g.fillRect(0, 0, 16, 16);
                    g.setColor(Color.MAGENTA);
                    g.fillRect(0, 8, 8, 8);
                    g.fillRect(8, 0, 8, 8);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)img, "PNG", baos);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    return baos.toByteArray();
                }
            });
        }
        resourcePack.put("assets/" + ore.name().func_110624_b() + "/textures/" + ore.name().func_110623_a() + ".png.mcmeta", () -> {
            try {
                CompactOreTexture.TextureInfo info = CompactOreTexture.generate(null, ore.getBaseUnderlyingTexture(), ore.getBaseBlockRegistryName(), ore.getBaseOreTexture(), ore.getMaxOreLayerColorDiff());
                return info.generateMeta().toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOGGER.error("Failed to generate compact ore texture for " + ore.name().func_110623_a() + ", using missing texture instead.");
                this.logExceptionCauseList(e);
                throw e;
            }
        });
    }

    private void makeOreTags(Map<String, Supplier<byte[]>> resourcePack, List<CompactOre> ores) {
        JsonObject tag = new JsonObject();
        tag.addProperty("replace", Boolean.valueOf(false));
        JsonArray values = new JsonArray();
        for (CompactOre ore : ores) {
            values.add(ore.name().toString());
        }
        tag.add("values", (JsonElement)values);
        byte[] bytes = tag.toString().getBytes(StandardCharsets.UTF_8);
        resourcePack.put("data/forge/tags/blocks/ores.json", () -> bytes);
        resourcePack.put("data/forge/tags/items/ores.json", () -> bytes);
    }

    private void logExceptionCauseList(Throwable th) {
        do {
            LOGGER.error("   Caused by " + th.getClass().getName() + ": " + th.getMessage());
        } while ((th = th.getCause()) != null);
    }

    public void func_230230_a_(Consumer<ResourcePackInfo> packConsumer, ResourcePackInfo.IFactory iFactory) {
        packConsumer.accept(ResourcePackInfo.func_195793_a((String)PACK_NAME, (boolean)true, this::getPack, (ResourcePackInfo.IFactory)iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM, (IPackNameDecorator)IPackNameDecorator.field_232626_b_));
    }
}

