/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigFile;
import doublenegation.mods.compactores.config.ConfigFileManager;
import doublenegation.mods.compactores.config.OreBuilder;
import doublenegation.mods.compactores.config.OreConfigHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<CompactOre> loadOres() {
        LOGGER.info("Loading compactores configuration...");
        ConfigFileManager cfm = new ConfigFileManager();
        try {
            cfm.load();
            ConfigFile globalConfig = null;
            HashMap<ResourceLocation, ConfigFile> configs = new HashMap<ResourceLocation, ConfigFile>();
            for (FileConfig cfg : cfm.getConfigs()) {
                ConfigFile f = new ConfigFile(cfg);
                if (f.hasGlobalConfig()) {
                    if (globalConfig == null) {
                        globalConfig = f;
                    } else {
                        LOGGER.fatal("Multiple global configs found:");
                        LOGGER.fatal("\t" + globalConfig.getFilenameNamespace() + ".toml");
                        LOGGER.fatal("\t" + f.getFilenameNamespace() + ".toml");
                        throw new IllegalStateException("Multiple global configs found - aborting!");
                    }
                }
                for (ResourceLocation ore : f.getOres()) {
                    if (!configs.containsKey(ore)) {
                        configs.put(ore, f);
                        continue;
                    }
                    ConfigFile g = (ConfigFile)configs.get(ore);
                    LOGGER.fatal("Ore " + ore + " is defined multiple times:");
                    LOGGER.fatal("\tin " + g.getFilenameNamespace() + ".toml");
                    LOGGER.fatal("\tin " + f.getFilenameNamespace() + ".toml");
                    throw new IllegalStateException("Ore " + ore + " is defined multiple times - aborting!");
                }
            }
            if (globalConfig != null) {
                Optional.ofNullable(globalConfig.getGlobalConfigValue("generateTexture")).filter(v -> v instanceof Boolean).ifPresent(v -> OreBuilder.setGlobalGenerateTexture((Boolean)v));
                Optional.ofNullable(globalConfig.getGlobalConfigValue("maxOreLayerColorDiff")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMaxOreLayerColorDiff((Integer)v));
                Optional.ofNullable(globalConfig.getGlobalConfigValue("redrawOreBase")).filter(v -> v instanceof Boolean).ifPresent(v -> CompactOreTexture.setRedrawOreBase((Boolean)v));
                Optional.ofNullable(globalConfig.getGlobalConfigValue("minRolls")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMinRolls((Integer)v));
                Optional.ofNullable(globalConfig.getGlobalConfigValue("maxRolls")).filter(v -> v instanceof Integer).ifPresent(v -> OreBuilder.setGlobalMaxRolls((Integer)v));
                Optional.ofNullable(globalConfig.getGlobalConfigValue("spawnProbability")).filter(v -> v instanceof Number).ifPresent(v -> OreBuilder.setGlobalSpawnProbability((float)((Double)v).doubleValue()));
            }
            OreBuilderFactoryProvider obfp = new OreBuilderFactoryProvider();
            ArrayList<CompactOre> enabledOres = new ArrayList<CompactOre>();
            HashSet<String> activeOreMods = new HashSet<String>();
            HashSet<String> inactiveOreMods = new HashSet<String>();
            int disabledOres = 0;
            ModList modList = ModList.get();
            for (ResourceLocation orename : configs.keySet()) {
                OreConfigHolder och = new OreConfigHolder(orename, obfp);
                och.setConfig((ConfigFile)configs.get(orename));
                if (modList.isLoaded(orename.func_110624_b())) {
                    try {
                        enabledOres.add(och.buildOre());
                    }
                    catch (RuntimeException ex) {
                        LOGGER.warn("Failed to load ore " + orename + ": " + ex.getClass().getName() + ": " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    activeOreMods.add(orename.func_110624_b());
                    continue;
                }
                ++disabledOres;
                inactiveOreMods.add(orename.func_110624_b());
            }
            LOGGER.info("Successfully loaded " + (enabledOres.size() + disabledOres) + " compact ores for a total of " + (activeOreMods.size() + inactiveOreMods.size()) + " mods.");
            LOGGER.info("\t" + enabledOres.size() + " ores for " + activeOreMods.size() + " mods are active.");
            LOGGER.info("\t" + disabledOres + " ores for " + inactiveOreMods.size() + " mods will not be enabled because their mod is not loaded.");
            enabledOres.sort(CompactOre::compareTo);
            enabledOres.forEach(o -> LOGGER.debug((Object)o.getBaseBlockRegistryName()));
            return enabledOres;
        }
        catch (Exception e) {
            cfm.handleConfigLoadingFailed(e);
            return new ArrayList<CompactOre>(0);
        }
    }

    private static class OreBuilderFactoryProvider
    implements Function<ConfigFile, OreBuilder> {
        private final Map<ConfigFile, OreBuilder.Factory> factories = new HashMap<ConfigFile, OreBuilder.Factory>();

        private OreBuilderFactoryProvider() {
        }

        @Override
        public synchronized OreBuilder apply(ConfigFile config) {
            if (this.factories.containsKey(config)) {
                return this.factories.get(config).create();
            }
            OreBuilder.Factory fact = this.createFactory(config);
            this.factories.put(config, fact);
            return fact.create();
        }

        private OreBuilder.Factory createFactory(ConfigFile config) {
            OreBuilder.Factory fact = OreBuilder.Factory.createFactory();
            if (config.hasLocalConfig()) {
                fact.generateTexture((Boolean)config.getLocalConfigValue("generateTexture")).maxOreLayerColorDiff((Integer)config.getLocalConfigValue("maxOreLayerColorDiff")).oreTexture(Utils.parseResourceLocationExtra((String)config.getLocalConfigValue("oreTexture"), config.getFilenameNamespace())).rockTexture(Utils.parseResourceLocationExtra((String)config.getLocalConfigValue("rockTexture"), config.getFilenameNamespace())).lateGeneration((Boolean)config.getLocalConfigValue("lateGeneration")).useGetDrops((Boolean)config.getLocalConfigValue("useGetDrops")).minRolls((Integer)config.getLocalConfigValue("minRolls")).maxRolls((Integer)config.getLocalConfigValue("maxRolls")).spawnProbability((Float)config.getLocalConfigValue("spawnProbability"));
            }
            return fact;
        }
    }
}

