/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigFile;
import doublenegation.mods.compactores.config.OreBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class OreConfigHolder {
    private final ResourceLocation oreName;
    private ConfigFile config;
    private final Function<ConfigFile, OreBuilder> oreBuilderProvider;

    public OreConfigHolder(ResourceLocation oreName, Function<ConfigFile, OreBuilder> oreBuilderProvider) {
        this.oreName = oreName;
        this.oreBuilderProvider = oreBuilderProvider;
    }

    public synchronized void setConfig(ConfigFile config) {
        if (this.config != null) {
            throw new IllegalStateException("Config already set");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is null!");
        }
        if (!config.containsOre(this.oreName)) {
            throw new IllegalArgumentException("Config does not support ore (" + this.oreName + ")");
        }
        this.config = config;
    }

    public CompactOre buildOre() {
        if (this.config == null) {
            throw new IllegalStateException("Cconfig is not set");
        }
        return this.oreBuilderProvider.apply(this.config).generateTexture((Boolean)this.config.getOreConfigValue(this.oreName, "generateTexture")).maxOreLayerColorDiff((Integer)this.config.getOreConfigValue(this.oreName, "maxOreLayerColorDiff")).oreTexture(Utils.parseResourceLocationExtra((String)this.config.getOreConfigValue(this.oreName, "oreTexture"), this.config.getFilenameNamespace())).rockTexture(Utils.parseResourceLocationExtra((String)this.config.getOreConfigValue(this.oreName, "rockTexture"), this.config.getFilenameNamespace())).lateGeneration((Boolean)this.config.getOreConfigValue(this.oreName, "lateGeneration")).useGetDrops((Boolean)this.config.getOreConfigValue(this.oreName, "useGetDrops")).minRolls(Optional.ofNullable(this.config).map(c -> c.getOreConfigValue(this.oreName, "minRolls")).orElse(null)).maxRolls(Optional.ofNullable(this.config).map(c -> c.getOreConfigValue(this.oreName, "maxRolls")).orElse(null)).spawnProbability(Optional.ofNullable(this.config).map(c -> c.getOreConfigValue(this.oreName, "spawnProbability")).map(v -> Float.valueOf((float)((Double)v).doubleValue())).orElse(null)).baseBlock(this.oreName).build();
    }
}

